/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.client;

import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.time.Duration;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class McpSyncClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(McpSyncClient.class);
    private static final long DEFAULT_CLOSE_TIMEOUT_MS = 10000L;
    private final McpAsyncClient delegate;
    private final Supplier<McpTransportContext> contextProvider;

    McpSyncClient(McpAsyncClient delegate, Supplier<McpTransportContext> contextProvider) {
        Assert.notNull(delegate, "The delegate can not be null");
        Assert.notNull(contextProvider, "The contextProvider can not be null");
        this.delegate = delegate;
        this.contextProvider = contextProvider;
    }

    public McpSchema.InitializeResult getCurrentInitializationResult() {
        return this.delegate.getCurrentInitializationResult();
    }

    public McpSchema.ServerCapabilities getServerCapabilities() {
        return this.delegate.getServerCapabilities();
    }

    public String getServerInstructions() {
        return this.delegate.getServerInstructions();
    }

    public McpSchema.Implementation getServerInfo() {
        return this.delegate.getServerInfo();
    }

    public boolean isInitialized() {
        return this.delegate.isInitialized();
    }

    public McpSchema.ClientCapabilities getClientCapabilities() {
        return this.delegate.getClientCapabilities();
    }

    public McpSchema.Implementation getClientInfo() {
        return this.delegate.getClientInfo();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public boolean closeGracefully() {
        try {
            this.delegate.closeGracefully().block(Duration.ofMillis(10000L));
        }
        catch (RuntimeException e) {
            logger.warn("Client didn't close within timeout of {} ms.", (Object)10000L, (Object)e);
            return false;
        }
        return true;
    }

    public McpSchema.InitializeResult initialize() {
        return this.withProvidedContext(this.delegate.initialize()).block();
    }

    public void rootsListChangedNotification() {
        this.withProvidedContext(this.delegate.rootsListChangedNotification()).block();
    }

    public void addRoot(McpSchema.Root root) {
        this.delegate.addRoot(root).block();
    }

    public void removeRoot(String rootUri) {
        this.delegate.removeRoot(rootUri).block();
    }

    public Object ping() {
        return this.withProvidedContext(this.delegate.ping()).block();
    }

    public McpSchema.CallToolResult callTool(McpSchema.CallToolRequest callToolRequest) {
        return this.withProvidedContext(this.delegate.callTool(callToolRequest)).block();
    }

    public McpSchema.ListToolsResult listTools() {
        return this.withProvidedContext(this.delegate.listTools()).block();
    }

    public McpSchema.ListToolsResult listTools(String cursor) {
        return this.withProvidedContext(this.delegate.listTools(cursor)).block();
    }

    public McpSchema.ListResourcesResult listResources() {
        return this.withProvidedContext(this.delegate.listResources()).block();
    }

    public McpSchema.ListResourcesResult listResources(String cursor) {
        return this.withProvidedContext(this.delegate.listResources(cursor)).block();
    }

    public McpSchema.ReadResourceResult readResource(McpSchema.Resource resource) {
        return this.withProvidedContext(this.delegate.readResource(resource)).block();
    }

    public McpSchema.ReadResourceResult readResource(McpSchema.ReadResourceRequest readResourceRequest) {
        return this.withProvidedContext(this.delegate.readResource(readResourceRequest)).block();
    }

    public McpSchema.ListResourceTemplatesResult listResourceTemplates() {
        return this.withProvidedContext(this.delegate.listResourceTemplates()).block();
    }

    public McpSchema.ListResourceTemplatesResult listResourceTemplates(String cursor) {
        return this.withProvidedContext(this.delegate.listResourceTemplates(cursor)).block();
    }

    public void subscribeResource(McpSchema.SubscribeRequest subscribeRequest) {
        this.withProvidedContext(this.delegate.subscribeResource(subscribeRequest)).block();
    }

    public void unsubscribeResource(McpSchema.UnsubscribeRequest unsubscribeRequest) {
        this.withProvidedContext(this.delegate.unsubscribeResource(unsubscribeRequest)).block();
    }

    public McpSchema.ListPromptsResult listPrompts() {
        return this.withProvidedContext(this.delegate.listPrompts()).block();
    }

    public McpSchema.ListPromptsResult listPrompts(String cursor) {
        return this.withProvidedContext(this.delegate.listPrompts(cursor)).block();
    }

    public McpSchema.GetPromptResult getPrompt(McpSchema.GetPromptRequest getPromptRequest) {
        return this.withProvidedContext(this.delegate.getPrompt(getPromptRequest)).block();
    }

    public void setLoggingLevel(McpSchema.LoggingLevel loggingLevel) {
        this.withProvidedContext(this.delegate.setLoggingLevel(loggingLevel)).block();
    }

    public McpSchema.CompleteResult completeCompletion(McpSchema.CompleteRequest completeRequest) {
        return this.withProvidedContext(this.delegate.completeCompletion(completeRequest)).block();
    }

    private <T> Mono<T> withProvidedContext(Mono<T> action) {
        return action.contextWrite(ctx -> ctx.put("MCP_TRANSPORT_CONTEXT", this.contextProvider.get()));
    }
}

