/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.vector.request.ranker;

import io.milvus.common.clientenum.FunctionType;
import io.milvus.common.utils.JsonUtils;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BoostRanker
extends CreateCollectionReq.Function {
    private String filter;
    private Float weight;
    private Long randomScoreSeed;
    private String randomScoreField;

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.RERANK;
    }

    @Override
    public Map<String, String> getParams() {
        Map<String, String> props = super.getParams();
        props.put("reranker", "boost");
        if (!StringUtils.isEmpty((CharSequence)this.filter)) {
            props.put("filter", this.filter);
        }
        if (this.weight != null) {
            props.put("weight", this.weight.toString());
        }
        HashMap<String, Object> randomScore = new HashMap<String, Object>();
        if (this.randomScoreSeed != null) {
            randomScore.put("seed", this.randomScoreSeed);
        }
        if (!StringUtils.isEmpty((CharSequence)this.randomScoreField)) {
            randomScore.put("field", this.randomScoreField);
        }
        if (!randomScore.isEmpty()) {
            props.put("random_score", JsonUtils.toJson(randomScore));
        }
        return props;
    }

    protected BoostRanker(BoostRankerBuilder<?, ?> b) {
        super(b);
        this.filter = ((BoostRankerBuilder)b).filter;
        this.weight = ((BoostRankerBuilder)b).weight;
        this.randomScoreSeed = ((BoostRankerBuilder)b).randomScoreSeed;
        this.randomScoreField = ((BoostRankerBuilder)b).randomScoreField;
    }

    public static BoostRankerBuilder<?, ?> builder() {
        return new BoostRankerBuilderImpl();
    }

    private static final class BoostRankerBuilderImpl
    extends BoostRankerBuilder<BoostRanker, BoostRankerBuilderImpl> {
        private BoostRankerBuilderImpl() {
        }

        @Override
        protected BoostRankerBuilderImpl self() {
            return this;
        }

        @Override
        public BoostRanker build() {
            return new BoostRanker(this);
        }
    }

    public static abstract class BoostRankerBuilder<C extends BoostRanker, B extends BoostRankerBuilder<C, B>>
    extends CreateCollectionReq.Function.FunctionBuilder<C, B> {
        private String filter;
        private Float weight;
        private Long randomScoreSeed;
        private String randomScoreField;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B filter(String filter) {
            this.filter = filter;
            return (B)this.self();
        }

        public B weight(Float weight) {
            this.weight = weight;
            return (B)this.self();
        }

        public B randomScoreSeed(Long randomScoreSeed) {
            this.randomScoreSeed = randomScoreSeed;
            return (B)this.self();
        }

        public B randomScoreField(String randomScoreField) {
            this.randomScoreField = randomScoreField;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "BoostRanker.BoostRankerBuilder(super=" + super.toString() + ", filter=" + this.filter + ", weight=" + this.weight + ", randomScoreSeed=" + this.randomScoreSeed + ", randomScoreField=" + this.randomScoreField + ")";
        }
    }
}

