/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.vector.request.data;

import io.milvus.grpc.PlaceholderType;
import io.milvus.v2.exception.ErrorCode;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.vector.request.data.BaseVector;
import java.util.ArrayList;
import java.util.List;

public class EmbeddingList
implements BaseVector {
    private List<BaseVector> data = new ArrayList<BaseVector>();

    public void add(BaseVector vector) {
        if (!this.data.isEmpty() && this.data.get(0).getPlaceholderType() != vector.getPlaceholderType()) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Not allow to add different types of vector");
        }
        this.data.add(vector);
    }

    @Override
    public PlaceholderType getPlaceholderType() {
        if (this.data.isEmpty()) {
            return PlaceholderType.None;
        }
        PlaceholderType pt = this.data.get(0).getPlaceholderType();
        switch (pt) {
            case FloatVector: {
                return PlaceholderType.EmbListFloatVector;
            }
            case BinaryVector: {
                return PlaceholderType.EmbListBinaryVector;
            }
            case Float16Vector: {
                return PlaceholderType.EmbListFloat16Vector;
            }
            case BFloat16Vector: {
                return PlaceholderType.EmbListBFloat16Vector;
            }
            case SparseFloatVector: {
                return PlaceholderType.EmbListSparseFloatVector;
            }
            case Int8Vector: {
                return PlaceholderType.EmbListInt8Vector;
            }
        }
        throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Unsupported vector type: " + pt.name());
    }

    @Override
    public Object getData() {
        if (this.data.isEmpty()) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "EmbeddingList is empty");
        }
        PlaceholderType pt = this.data.get(0).getPlaceholderType();
        switch (pt) {
            case FloatVector: {
                ArrayList floats = new ArrayList();
                for (BaseVector vec : this.data) {
                    floats.addAll((List)vec.getData());
                }
                return floats;
            }
        }
        throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Unsupported vector type: " + pt.name());
    }
}

