/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.cdc.request;

import io.milvus.grpc.ConnectionParam;
import io.milvus.grpc.MilvusCluster;
import java.util.List;
import java.util.Objects;

public class MilvusCluster {
    private String clusterId;
    private String uri;
    private String token;
    private List<String> pchannels;

    public io.milvus.grpc.MilvusCluster toGRPC() {
        ConnectionParam.Builder connectionParamBuilder = ConnectionParam.newBuilder().setUri(this.uri);
        if (this.token != null) {
            connectionParamBuilder.setToken(this.token);
        }
        MilvusCluster.Builder builder = io.milvus.grpc.MilvusCluster.newBuilder().setClusterId(this.clusterId).setConnectionParam(connectionParamBuilder);
        if (this.pchannels != null) {
            builder.addAllPchannels(this.pchannels);
        }
        return builder.build();
    }

    private MilvusCluster(Builder builder) {
        this.clusterId = builder.clusterId;
        this.uri = builder.uri;
        this.token = builder.token;
        this.pchannels = builder.pchannels;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public List<String> getPchannels() {
        return this.pchannels;
    }

    public void setPchannels(List<String> pchannels) {
        this.pchannels = pchannels;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MilvusCluster that = (MilvusCluster)o;
        return Objects.equals(this.clusterId, that.clusterId) && Objects.equals(this.uri, that.uri) && Objects.equals(this.token, that.token) && Objects.equals(this.pchannels, that.pchannels);
    }

    public int hashCode() {
        return Objects.hash(this.clusterId, this.uri, this.token, this.pchannels);
    }

    public String toString() {
        return "MilvusCluster{clusterId='" + this.clusterId + '\'' + ", uri='" + this.uri + '\'' + ", token='" + this.token + '\'' + ", pchannels=" + this.pchannels + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String clusterId;
        private String uri;
        private String token;
        private List<String> pchannels;

        public Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public Builder pchannels(List<String> pchannels) {
            this.pchannels = pchannels;
            return this;
        }

        public MilvusCluster build() {
            return new MilvusCluster(this);
        }
    }
}

