/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.client;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.milvus.grpc.ClientInfo;
import io.milvus.grpc.ConnectRequest;
import io.milvus.grpc.ConnectResponse;
import io.milvus.grpc.ErrorCode;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.orm.iterator.QueryIterator;
import io.milvus.orm.iterator.SearchIterator;
import io.milvus.orm.iterator.SearchIteratorV2;
import io.milvus.v2.client.ConnectConfig;
import io.milvus.v2.client.RetryConfig;
import io.milvus.v2.service.cdc.CDCService;
import io.milvus.v2.service.cdc.request.UpdateReplicateConfigurationReq;
import io.milvus.v2.service.cdc.response.UpdateReplicateConfigurationResp;
import io.milvus.v2.service.collection.CollectionService;
import io.milvus.v2.service.collection.request.AddCollectionFieldReq;
import io.milvus.v2.service.collection.request.AlterCollectionFieldReq;
import io.milvus.v2.service.collection.request.AlterCollectionPropertiesReq;
import io.milvus.v2.service.collection.request.AlterCollectionReq;
import io.milvus.v2.service.collection.request.BatchDescribeCollectionReq;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.collection.request.DescribeCollectionReq;
import io.milvus.v2.service.collection.request.DescribeReplicasReq;
import io.milvus.v2.service.collection.request.DropCollectionFieldPropertiesReq;
import io.milvus.v2.service.collection.request.DropCollectionPropertiesReq;
import io.milvus.v2.service.collection.request.DropCollectionReq;
import io.milvus.v2.service.collection.request.GetCollectionStatsReq;
import io.milvus.v2.service.collection.request.GetLoadStateReq;
import io.milvus.v2.service.collection.request.HasCollectionReq;
import io.milvus.v2.service.collection.request.ListCollectionsReq;
import io.milvus.v2.service.collection.request.LoadCollectionReq;
import io.milvus.v2.service.collection.request.RefreshLoadReq;
import io.milvus.v2.service.collection.request.ReleaseCollectionReq;
import io.milvus.v2.service.collection.request.RenameCollectionReq;
import io.milvus.v2.service.collection.response.DescribeCollectionResp;
import io.milvus.v2.service.collection.response.DescribeReplicasResp;
import io.milvus.v2.service.collection.response.GetCollectionStatsResp;
import io.milvus.v2.service.collection.response.ListCollectionsResp;
import io.milvus.v2.service.database.DatabaseService;
import io.milvus.v2.service.database.request.AlterDatabasePropertiesReq;
import io.milvus.v2.service.database.request.AlterDatabaseReq;
import io.milvus.v2.service.database.request.CreateDatabaseReq;
import io.milvus.v2.service.database.request.DescribeDatabaseReq;
import io.milvus.v2.service.database.request.DropDatabasePropertiesReq;
import io.milvus.v2.service.database.request.DropDatabaseReq;
import io.milvus.v2.service.database.response.DescribeDatabaseResp;
import io.milvus.v2.service.database.response.ListDatabasesResp;
import io.milvus.v2.service.index.IndexService;
import io.milvus.v2.service.index.request.AlterIndexPropertiesReq;
import io.milvus.v2.service.index.request.AlterIndexReq;
import io.milvus.v2.service.index.request.CreateIndexReq;
import io.milvus.v2.service.index.request.DescribeIndexReq;
import io.milvus.v2.service.index.request.DropIndexPropertiesReq;
import io.milvus.v2.service.index.request.DropIndexReq;
import io.milvus.v2.service.index.request.ListIndexesReq;
import io.milvus.v2.service.index.response.DescribeIndexResp;
import io.milvus.v2.service.partition.PartitionService;
import io.milvus.v2.service.partition.request.CreatePartitionReq;
import io.milvus.v2.service.partition.request.DropPartitionReq;
import io.milvus.v2.service.partition.request.GetPartitionStatsReq;
import io.milvus.v2.service.partition.request.HasPartitionReq;
import io.milvus.v2.service.partition.request.ListPartitionsReq;
import io.milvus.v2.service.partition.request.LoadPartitionsReq;
import io.milvus.v2.service.partition.request.ReleasePartitionsReq;
import io.milvus.v2.service.partition.response.GetPartitionStatsResp;
import io.milvus.v2.service.rbac.RBACService;
import io.milvus.v2.service.rbac.request.AddPrivilegesToGroupReq;
import io.milvus.v2.service.rbac.request.CreatePrivilegeGroupReq;
import io.milvus.v2.service.rbac.request.CreateRoleReq;
import io.milvus.v2.service.rbac.request.CreateUserReq;
import io.milvus.v2.service.rbac.request.DescribeRoleReq;
import io.milvus.v2.service.rbac.request.DescribeUserReq;
import io.milvus.v2.service.rbac.request.DropPrivilegeGroupReq;
import io.milvus.v2.service.rbac.request.DropRoleReq;
import io.milvus.v2.service.rbac.request.DropUserReq;
import io.milvus.v2.service.rbac.request.GrantPrivilegeReq;
import io.milvus.v2.service.rbac.request.GrantPrivilegeReqV2;
import io.milvus.v2.service.rbac.request.GrantRoleReq;
import io.milvus.v2.service.rbac.request.ListPrivilegeGroupsReq;
import io.milvus.v2.service.rbac.request.RemovePrivilegesFromGroupReq;
import io.milvus.v2.service.rbac.request.RevokePrivilegeReq;
import io.milvus.v2.service.rbac.request.RevokePrivilegeReqV2;
import io.milvus.v2.service.rbac.request.RevokeRoleReq;
import io.milvus.v2.service.rbac.request.UpdatePasswordReq;
import io.milvus.v2.service.rbac.response.DescribeRoleResp;
import io.milvus.v2.service.rbac.response.DescribeUserResp;
import io.milvus.v2.service.rbac.response.ListPrivilegeGroupsResp;
import io.milvus.v2.service.resourcegroup.ResourceGroupService;
import io.milvus.v2.service.resourcegroup.request.CreateResourceGroupReq;
import io.milvus.v2.service.resourcegroup.request.DescribeResourceGroupReq;
import io.milvus.v2.service.resourcegroup.request.DropResourceGroupReq;
import io.milvus.v2.service.resourcegroup.request.ListResourceGroupsReq;
import io.milvus.v2.service.resourcegroup.request.TransferNodeReq;
import io.milvus.v2.service.resourcegroup.request.TransferReplicaReq;
import io.milvus.v2.service.resourcegroup.request.UpdateResourceGroupsReq;
import io.milvus.v2.service.resourcegroup.response.DescribeResourceGroupResp;
import io.milvus.v2.service.resourcegroup.response.ListResourceGroupsResp;
import io.milvus.v2.service.utility.UtilityService;
import io.milvus.v2.service.utility.request.AlterAliasReq;
import io.milvus.v2.service.utility.request.CompactReq;
import io.milvus.v2.service.utility.request.CreateAliasReq;
import io.milvus.v2.service.utility.request.DescribeAliasReq;
import io.milvus.v2.service.utility.request.DropAliasReq;
import io.milvus.v2.service.utility.request.FlushReq;
import io.milvus.v2.service.utility.request.GetCompactionStateReq;
import io.milvus.v2.service.utility.request.GetPersistentSegmentInfoReq;
import io.milvus.v2.service.utility.request.GetQuerySegmentInfoReq;
import io.milvus.v2.service.utility.request.ListAliasesReq;
import io.milvus.v2.service.utility.response.CheckHealthResp;
import io.milvus.v2.service.utility.response.CompactResp;
import io.milvus.v2.service.utility.response.DescribeAliasResp;
import io.milvus.v2.service.utility.response.FlushResp;
import io.milvus.v2.service.utility.response.GetCompactionStateResp;
import io.milvus.v2.service.utility.response.GetPersistentSegmentInfoResp;
import io.milvus.v2.service.utility.response.GetQuerySegmentInfoResp;
import io.milvus.v2.service.utility.response.ListAliasResp;
import io.milvus.v2.service.vector.VectorService;
import io.milvus.v2.service.vector.request.DeleteReq;
import io.milvus.v2.service.vector.request.GetReq;
import io.milvus.v2.service.vector.request.HybridSearchReq;
import io.milvus.v2.service.vector.request.InsertReq;
import io.milvus.v2.service.vector.request.QueryIteratorReq;
import io.milvus.v2.service.vector.request.QueryReq;
import io.milvus.v2.service.vector.request.RunAnalyzerReq;
import io.milvus.v2.service.vector.request.SearchIteratorReq;
import io.milvus.v2.service.vector.request.SearchIteratorReqV2;
import io.milvus.v2.service.vector.request.SearchReq;
import io.milvus.v2.service.vector.request.UpsertReq;
import io.milvus.v2.service.vector.response.DeleteResp;
import io.milvus.v2.service.vector.response.GetResp;
import io.milvus.v2.service.vector.response.InsertResp;
import io.milvus.v2.service.vector.response.QueryResp;
import io.milvus.v2.service.vector.response.RunAnalyzerResp;
import io.milvus.v2.service.vector.response.SearchResp;
import io.milvus.v2.service.vector.response.UpsertResp;
import io.milvus.v2.utils.ClientUtils;
import io.milvus.v2.utils.RpcUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MilvusClientV2 {
    private static final Logger logger = LoggerFactory.getLogger(MilvusClientV2.class);
    private ManagedChannel channel;
    private MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub;
    private final ClientUtils clientUtils = new ClientUtils();
    private final DatabaseService databaseService = new DatabaseService();
    private final CollectionService collectionService = new CollectionService();
    private final IndexService indexService = new IndexService();
    private final VectorService vectorService = new VectorService();
    private final PartitionService partitionService = new PartitionService();
    private final RBACService rbacService = new RBACService();
    private final ResourceGroupService rgroupService = new ResourceGroupService();
    private final UtilityService utilityService = new UtilityService();
    private final CDCService cdcService = new CDCService();
    private RpcUtils rpcUtils = new RpcUtils();
    private ConnectConfig connectConfig;

    public MilvusClientV2(ConnectConfig connectConfig) {
        if (connectConfig != null) {
            this.connect(connectConfig);
            this.initServices(connectConfig.getDbName());
        }
    }

    private void initServices(String dbName) {
        this.databaseService.setCurrentDbName(dbName);
        this.collectionService.setCurrentDbName(dbName);
        this.indexService.setCurrentDbName(dbName);
        this.vectorService.setCurrentDbName(dbName);
        this.vectorService.cleanCollectionCache();
        this.partitionService.setCurrentDbName(dbName);
        this.rbacService.setCurrentDbName(dbName);
        this.rgroupService.setCurrentDbName(dbName);
        this.utilityService.setCurrentDbName(dbName);
    }

    private void connect(ConnectConfig connectConfig) {
        this.connectConfig = connectConfig;
        try {
            if (this.channel != null) {
                this.close(3L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.channel = this.clientUtils.getChannel(connectConfig);
        this.blockingStub = (MilvusServiceGrpc.MilvusServiceBlockingStub)MilvusServiceGrpc.newBlockingStub((Channel)this.channel).withWaitForReady();
        this.connect(connectConfig, this.blockingStub);
        if (connectConfig.getDbName() != null) {
            this.clientUtils.checkDatabaseExist(this.blockingStub, connectConfig.getDbName());
        }
    }

    private MilvusServiceGrpc.MilvusServiceBlockingStub getRpcStub() {
        if (this.connectConfig != null && this.connectConfig.getRpcDeadlineMs() > 0L) {
            return (MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withDeadlineAfter(this.connectConfig.getRpcDeadlineMs(), TimeUnit.MILLISECONDS);
        }
        return this.blockingStub;
    }

    private void connect(ConnectConfig connectConfig, MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub) {
        String userName = connectConfig.getUsername();
        if (userName == null) {
            userName = "";
        }
        ClientInfo info = ClientInfo.newBuilder().setSdkType("Java").setSdkVersion(this.clientUtils.getSDKVersion()).setUser(userName).setHost(this.clientUtils.getHostName()).setLocalTime(this.clientUtils.getLocalTimeStr()).build();
        ConnectRequest req = ConnectRequest.newBuilder().setClientInfo(info).build();
        ConnectResponse resp = ((MilvusServiceGrpc.MilvusServiceBlockingStub)blockingStub.withDeadlineAfter(connectConfig.getConnectTimeoutMs(), TimeUnit.MILLISECONDS)).connect(req);
        if (resp.getStatus().getCode() != 0 || !resp.getStatus().getErrorCode().equals((Object)ErrorCode.Success)) {
            throw new RuntimeException("Failed to initialize connection. Error: " + resp.getStatus().getReason());
        }
    }

    public void retryConfig(RetryConfig retryConfig) {
        this.rpcUtils.retryConfig(retryConfig);
    }

    public MilvusClientV2 withRetry(RetryConfig retryConfig) {
        this.rpcUtils.retryConfig(retryConfig);
        return this;
    }

    public MilvusClientV2 withTimeout(long timeout, TimeUnit timeoutUnit) {
        long nn = timeoutUnit.toNanos(timeout);
        long ms = nn == 0L ? 0L : (nn < 1000000L ? 1L : nn / 1000000L);
        this.connectConfig.setRpcDeadlineMs(ms);
        return this;
    }

    public String currentUsedDatabase() {
        String dbName = this.connectConfig.getDbName();
        if (StringUtils.isEmpty((CharSequence)dbName)) {
            return "default";
        }
        return dbName;
    }

    public void useDatabase(@NonNull String dbName) throws InterruptedException {
        if (dbName == null) {
            throw new NullPointerException("dbName is marked non-null but is null");
        }
        this.clientUtils.checkDatabaseExist(this.getRpcStub(), dbName);
        try {
            this.connectConfig.setDbName(dbName);
            this.close(3L);
            this.connect(this.connectConfig);
            this.initServices(dbName);
        }
        catch (InterruptedException e) {
            logger.error("close connect error");
            throw new RuntimeException(e);
        }
    }

    public void createDatabase(CreateDatabaseReq request) {
        this.rpcUtils.retry(() -> this.databaseService.createDatabase(this.getRpcStub(), request));
    }

    public void dropDatabase(DropDatabaseReq request) {
        this.rpcUtils.retry(() -> this.databaseService.dropDatabase(this.getRpcStub(), request));
    }

    public ListDatabasesResp listDatabases() {
        return this.rpcUtils.retry(() -> this.databaseService.listDatabases(this.getRpcStub()));
    }

    @Deprecated
    public void alterDatabase(AlterDatabaseReq request) {
        this.alterDatabaseProperties((AlterDatabasePropertiesReq)((AlterDatabasePropertiesReq.AlterDatabasePropertiesReqBuilder)((AlterDatabasePropertiesReq.AlterDatabasePropertiesReqBuilder)AlterDatabasePropertiesReq.builder().databaseName(request.getDatabaseName())).properties(request.getProperties())).build());
    }

    public void alterDatabaseProperties(AlterDatabasePropertiesReq request) {
        this.rpcUtils.retry(() -> this.databaseService.alterDatabaseProperties(this.getRpcStub(), request));
    }

    public void dropDatabaseProperties(DropDatabasePropertiesReq request) {
        this.rpcUtils.retry(() -> this.databaseService.dropDatabaseProperties(this.getRpcStub(), request));
    }

    public DescribeDatabaseResp describeDatabase(DescribeDatabaseReq request) {
        return this.rpcUtils.retry(() -> this.databaseService.describeDatabase(this.getRpcStub(), request));
    }

    public void createCollection(CreateCollectionReq request) {
        this.rpcUtils.retry(() -> this.collectionService.createCollection(this.getRpcStub(), request));
    }

    @Deprecated
    public CreateCollectionReq.CollectionSchema createSchema() {
        return CollectionService.createSchema();
    }

    public static CreateCollectionReq.CollectionSchema CreateSchema() {
        return CollectionService.createSchema();
    }

    public ListCollectionsResp listCollections() {
        return this.rpcUtils.retry(() -> this.collectionService.listCollections(this.getRpcStub(), ""));
    }

    public ListCollectionsResp listCollectionsV2(ListCollectionsReq request) {
        return this.rpcUtils.retry(() -> this.collectionService.listCollections(this.getRpcStub(), request.getDatabaseName()));
    }

    public void dropCollection(DropCollectionReq request) {
        this.rpcUtils.retry(() -> this.collectionService.dropCollection(this.getRpcStub(), request));
        this.vectorService.removeCollectionCache(request.getDatabaseName(), request.getCollectionName());
    }

    @Deprecated
    public void alterCollection(AlterCollectionReq request) {
        this.alterCollectionProperties((AlterCollectionPropertiesReq)((AlterCollectionPropertiesReq.AlterCollectionPropertiesReqBuilder)((AlterCollectionPropertiesReq.AlterCollectionPropertiesReqBuilder)((AlterCollectionPropertiesReq.AlterCollectionPropertiesReqBuilder)AlterCollectionPropertiesReq.builder().collectionName(request.getCollectionName())).databaseName(request.getDatabaseName())).properties(request.getProperties())).build());
    }

    public void alterCollectionProperties(AlterCollectionPropertiesReq request) {
        this.rpcUtils.retry(() -> this.collectionService.alterCollectionProperties(this.getRpcStub(), request));
    }

    public void addCollectionField(AddCollectionFieldReq request) {
        this.rpcUtils.retry(() -> this.collectionService.addCollectionField(this.getRpcStub(), request));
    }

    public void alterCollectionField(AlterCollectionFieldReq request) {
        this.rpcUtils.retry(() -> this.collectionService.alterCollectionField(this.getRpcStub(), request));
    }

    public void dropCollectionProperties(DropCollectionPropertiesReq request) {
        this.rpcUtils.retry(() -> this.collectionService.dropCollectionProperties(this.getRpcStub(), request));
    }

    public void dropCollectionFieldProperties(DropCollectionFieldPropertiesReq request) {
        this.rpcUtils.retry(() -> this.collectionService.dropCollectionFieldProperties(this.getRpcStub(), request));
    }

    public Boolean hasCollection(HasCollectionReq request) {
        return this.rpcUtils.retry(() -> this.collectionService.hasCollection(this.getRpcStub(), request));
    }

    public DescribeCollectionResp describeCollection(DescribeCollectionReq request) {
        return this.rpcUtils.retry(() -> this.collectionService.describeCollection(this.getRpcStub(), request));
    }

    public List<DescribeCollectionResp> batchDescribeCollection(BatchDescribeCollectionReq request) {
        return this.rpcUtils.retry(() -> this.collectionService.batchDescribeCollections(this.getRpcStub(), request));
    }

    public GetCollectionStatsResp getCollectionStats(GetCollectionStatsReq request) {
        return this.rpcUtils.retry(() -> this.collectionService.getCollectionStats(this.getRpcStub(), request));
    }

    public void renameCollection(RenameCollectionReq request) {
        this.rpcUtils.retry(() -> this.collectionService.renameCollection(this.getRpcStub(), request));
    }

    public void loadCollection(LoadCollectionReq request) {
        this.rpcUtils.retry(() -> this.collectionService.loadCollection(this.getRpcStub(), request));
    }

    public void refreshLoad(RefreshLoadReq request) {
        this.rpcUtils.retry(() -> this.collectionService.refreshLoad(this.getRpcStub(), request));
    }

    public void releaseCollection(ReleaseCollectionReq request) {
        this.rpcUtils.retry(() -> this.collectionService.releaseCollection(this.getRpcStub(), request));
    }

    public Boolean getLoadState(GetLoadStateReq request) {
        return this.rpcUtils.retry(() -> this.collectionService.getLoadState(this.getRpcStub(), request));
    }

    public DescribeReplicasResp describeReplicas(DescribeReplicasReq request) {
        return this.rpcUtils.retry(() -> this.collectionService.describeReplicas(this.getRpcStub(), request));
    }

    public void createIndex(CreateIndexReq request) {
        this.rpcUtils.retry(() -> this.indexService.createIndex(this.getRpcStub(), request));
    }

    public void dropIndex(DropIndexReq request) {
        this.rpcUtils.retry(() -> this.indexService.dropIndex(this.getRpcStub(), request));
    }

    @Deprecated
    public void alterIndex(AlterIndexReq request) {
        this.alterIndexProperties((AlterIndexPropertiesReq)((AlterIndexPropertiesReq.AlterIndexPropertiesReqBuilder)((AlterIndexPropertiesReq.AlterIndexPropertiesReqBuilder)((AlterIndexPropertiesReq.AlterIndexPropertiesReqBuilder)((AlterIndexPropertiesReq.AlterIndexPropertiesReqBuilder)AlterIndexPropertiesReq.builder().collectionName(request.getCollectionName())).databaseName(request.getDatabaseName())).indexName(request.getIndexName())).properties(request.getProperties())).build());
    }

    public void alterIndexProperties(AlterIndexPropertiesReq request) {
        this.rpcUtils.retry(() -> this.indexService.alterIndexProperties(this.getRpcStub(), request));
    }

    public void dropIndexProperties(DropIndexPropertiesReq request) {
        this.rpcUtils.retry(() -> this.indexService.dropIndexProperties(this.getRpcStub(), request));
    }

    public DescribeIndexResp describeIndex(DescribeIndexReq request) {
        return this.rpcUtils.retry(() -> this.indexService.describeIndex(this.getRpcStub(), request));
    }

    public List<String> listIndexes(ListIndexesReq request) {
        return this.rpcUtils.retry(() -> this.indexService.listIndexes(this.getRpcStub(), request));
    }

    public InsertResp insert(InsertReq request) {
        return this.rpcUtils.retry(() -> this.vectorService.insert(this.getRpcStub(), request));
    }

    public UpsertResp upsert(UpsertReq request) {
        return this.rpcUtils.retry(() -> this.vectorService.upsert(this.getRpcStub(), request));
    }

    public DeleteResp delete(DeleteReq request) {
        return this.rpcUtils.retry(() -> this.vectorService.delete(this.getRpcStub(), request));
    }

    public GetResp get(GetReq request) {
        return this.rpcUtils.retry(() -> this.vectorService.get(this.getRpcStub(), request));
    }

    public QueryResp query(QueryReq request) {
        return this.rpcUtils.retry(() -> this.vectorService.query(this.getRpcStub(), request));
    }

    public SearchResp search(SearchReq request) {
        return this.rpcUtils.retry(() -> this.vectorService.search(this.getRpcStub(), request));
    }

    public SearchResp hybridSearch(HybridSearchReq request) {
        return this.rpcUtils.retry(() -> this.vectorService.hybridSearch(this.getRpcStub(), request));
    }

    public QueryIterator queryIterator(QueryIteratorReq request) {
        return this.rpcUtils.retry(() -> this.vectorService.queryIterator(this.getRpcStub(), request));
    }

    public SearchIterator searchIterator(SearchIteratorReq request) {
        return this.rpcUtils.retry(() -> this.vectorService.searchIterator(this.getRpcStub(), request));
    }

    public SearchIteratorV2 searchIteratorV2(SearchIteratorReqV2 request) {
        return this.rpcUtils.retry(() -> this.vectorService.searchIteratorV2(this.getRpcStub(), request));
    }

    public RunAnalyzerResp runAnalyzer(RunAnalyzerReq request) {
        return this.rpcUtils.retry(() -> this.vectorService.runAnalyzer(this.getRpcStub(), request));
    }

    public void createPartition(CreatePartitionReq request) {
        this.rpcUtils.retry(() -> this.partitionService.createPartition(this.getRpcStub(), request));
    }

    public void dropPartition(DropPartitionReq request) {
        this.rpcUtils.retry(() -> this.partitionService.dropPartition(this.getRpcStub(), request));
    }

    public Boolean hasPartition(HasPartitionReq request) {
        return this.rpcUtils.retry(() -> this.partitionService.hasPartition(this.getRpcStub(), request));
    }

    public List<String> listPartitions(ListPartitionsReq request) {
        return this.rpcUtils.retry(() -> this.partitionService.listPartitions(this.getRpcStub(), request));
    }

    public GetPartitionStatsResp getPartitionStats(GetPartitionStatsReq request) {
        return this.rpcUtils.retry(() -> this.partitionService.getPartitionStats(this.getRpcStub(), request));
    }

    public void loadPartitions(LoadPartitionsReq request) {
        this.rpcUtils.retry(() -> this.partitionService.loadPartitions(this.getRpcStub(), request));
    }

    public void releasePartitions(ReleasePartitionsReq request) {
        this.rpcUtils.retry(() -> this.partitionService.releasePartitions(this.getRpcStub(), request));
    }

    public List<String> listUsers() {
        return this.rpcUtils.retry(() -> this.rbacService.listUsers(this.getRpcStub()));
    }

    public DescribeUserResp describeUser(DescribeUserReq request) {
        return this.rpcUtils.retry(() -> this.rbacService.describeUser(this.getRpcStub(), request));
    }

    public void createUser(CreateUserReq request) {
        this.rpcUtils.retry(() -> this.rbacService.createUser(this.getRpcStub(), request));
    }

    public void updatePassword(UpdatePasswordReq request) {
        this.rpcUtils.retry(() -> this.rbacService.updatePassword(this.getRpcStub(), request));
    }

    public void dropUser(DropUserReq request) {
        this.rpcUtils.retry(() -> this.rbacService.dropUser(this.getRpcStub(), request));
    }

    public List<String> listRoles() {
        return this.rpcUtils.retry(() -> this.rbacService.listRoles(this.getRpcStub()));
    }

    public DescribeRoleResp describeRole(DescribeRoleReq request) {
        return this.rpcUtils.retry(() -> this.rbacService.describeRole(this.getRpcStub(), request));
    }

    public void createRole(CreateRoleReq request) {
        this.rpcUtils.retry(() -> this.rbacService.createRole(this.getRpcStub(), request));
    }

    public void dropRole(DropRoleReq request) {
        this.rpcUtils.retry(() -> this.rbacService.dropRole(this.getRpcStub(), request));
    }

    public void grantPrivilege(GrantPrivilegeReq request) {
        this.rpcUtils.retry(() -> this.rbacService.grantPrivilege(this.getRpcStub(), request));
    }

    public void revokePrivilege(RevokePrivilegeReq request) {
        this.rpcUtils.retry(() -> this.rbacService.revokePrivilege(this.getRpcStub(), request));
    }

    public void grantRole(GrantRoleReq request) {
        this.rpcUtils.retry(() -> this.rbacService.grantRole(this.getRpcStub(), request));
    }

    public void revokeRole(RevokeRoleReq request) {
        this.rpcUtils.retry(() -> this.rbacService.revokeRole(this.getRpcStub(), request));
    }

    public void createPrivilegeGroup(CreatePrivilegeGroupReq request) {
        this.rpcUtils.retry(() -> this.rbacService.createPrivilegeGroup(this.getRpcStub(), request));
    }

    public void dropPrivilegeGroup(DropPrivilegeGroupReq request) {
        this.rpcUtils.retry(() -> this.rbacService.dropPrivilegeGroup(this.getRpcStub(), request));
    }

    public ListPrivilegeGroupsResp listPrivilegeGroups(ListPrivilegeGroupsReq request) {
        return this.rpcUtils.retry(() -> this.rbacService.listPrivilegeGroups(this.getRpcStub(), request));
    }

    public void addPrivilegesToGroup(AddPrivilegesToGroupReq request) {
        this.rpcUtils.retry(() -> this.rbacService.addPrivilegesToGroup(this.getRpcStub(), request));
    }

    public void removePrivilegesFromGroup(RemovePrivilegesFromGroupReq request) {
        this.rpcUtils.retry(() -> this.rbacService.removePrivilegesFromGroup(this.getRpcStub(), request));
    }

    public void grantPrivilegeV2(GrantPrivilegeReqV2 request) {
        this.rpcUtils.retry(() -> this.rbacService.grantPrivilegeV2(this.getRpcStub(), request));
    }

    public void revokePrivilegeV2(RevokePrivilegeReqV2 request) {
        this.rpcUtils.retry(() -> this.rbacService.revokePrivilegeV2(this.getRpcStub(), request));
    }

    public void createResourceGroup(CreateResourceGroupReq request) {
        this.rpcUtils.retry(() -> this.rgroupService.createResourceGroup(this.getRpcStub(), request));
    }

    public void updateResourceGroups(UpdateResourceGroupsReq request) {
        this.rpcUtils.retry(() -> this.rgroupService.updateResourceGroups(this.getRpcStub(), request));
    }

    public void dropResourceGroup(DropResourceGroupReq request) {
        this.rpcUtils.retry(() -> this.rgroupService.dropResourceGroup(this.getRpcStub(), request));
    }

    public ListResourceGroupsResp listResourceGroups(ListResourceGroupsReq request) {
        return this.rpcUtils.retry(() -> this.rgroupService.listResourceGroups(this.getRpcStub(), request));
    }

    public DescribeResourceGroupResp describeResourceGroup(DescribeResourceGroupReq request) {
        return this.rpcUtils.retry(() -> this.rgroupService.describeResourceGroup(this.getRpcStub(), request));
    }

    public void transferNode(TransferNodeReq request) {
        this.rpcUtils.retry(() -> this.rgroupService.transferNode(this.getRpcStub(), request));
    }

    public void transferReplica(TransferReplicaReq request) {
        this.rpcUtils.retry(() -> this.rgroupService.transferReplica(this.getRpcStub(), request));
    }

    public void createAlias(CreateAliasReq request) {
        this.rpcUtils.retry(() -> this.utilityService.createAlias(this.getRpcStub(), request));
    }

    public void dropAlias(DropAliasReq request) {
        this.rpcUtils.retry(() -> this.utilityService.dropAlias(this.getRpcStub(), request));
    }

    public void alterAlias(AlterAliasReq request) {
        this.rpcUtils.retry(() -> this.utilityService.alterAlias(this.getRpcStub(), request));
    }

    public ListAliasResp listAliases(ListAliasesReq request) {
        return this.rpcUtils.retry(() -> this.utilityService.listAliases(this.getRpcStub(), request));
    }

    public DescribeAliasResp describeAlias(DescribeAliasReq request) {
        return this.rpcUtils.retry(() -> this.utilityService.describeAlias(this.getRpcStub(), request));
    }

    public void flush(FlushReq request) {
        FlushResp response = this.rpcUtils.retry(() -> this.utilityService.flush(this.getRpcStub(), request));
        MilvusServiceGrpc.MilvusServiceBlockingStub tempBlockingStub = (MilvusServiceGrpc.MilvusServiceBlockingStub)MilvusServiceGrpc.newBlockingStub((Channel)this.channel).withWaitForReady();
        if (request.getWaitFlushedTimeoutMs() > 0L) {
            tempBlockingStub = (MilvusServiceGrpc.MilvusServiceBlockingStub)tempBlockingStub.withDeadlineAfter(request.getWaitFlushedTimeoutMs(), TimeUnit.MILLISECONDS);
        }
        this.utilityService.waitFlush(tempBlockingStub, response);
    }

    public GetPersistentSegmentInfoResp getPersistentSegmentInfo(GetPersistentSegmentInfoReq request) {
        return this.rpcUtils.retry(() -> this.utilityService.getPersistentSegmentInfo(this.getRpcStub(), request));
    }

    public GetQuerySegmentInfoResp getQuerySegmentInfo(GetQuerySegmentInfoReq request) {
        return this.rpcUtils.retry(() -> this.utilityService.getQuerySegmentInfo(this.getRpcStub(), request));
    }

    public CompactResp compact(CompactReq request) {
        return this.rpcUtils.retry(() -> this.utilityService.compact(this.getRpcStub(), request));
    }

    public GetCompactionStateResp getCompactionState(GetCompactionStateReq request) {
        return this.rpcUtils.retry(() -> this.utilityService.getCompactionState(this.getRpcStub(), request));
    }

    public String getServerVersion() {
        return this.rpcUtils.retry(() -> this.clientUtils.getServerVersion(this.getRpcStub()));
    }

    public CheckHealthResp checkHealth() {
        return this.rpcUtils.retry(() -> this.utilityService.checkHealth(this.getRpcStub()));
    }

    public UpdateReplicateConfigurationResp updateReplicateConfiguration(UpdateReplicateConfigurationReq request) {
        return this.rpcUtils.retry(() -> this.cdcService.updateReplicateConfiguration(this.getRpcStub(), request));
    }

    public void close(long maxWaitSeconds) throws InterruptedException {
        if (this.channel != null) {
            this.channel.shutdownNow();
            this.channel.awaitTermination(maxWaitSeconds, TimeUnit.SECONDS);
        }
    }

    public void close() {
        try {
            this.close(TimeUnit.MINUTES.toSeconds(1L));
        }
        catch (InterruptedException e) {
            logger.error("Interrupted during shutdown Milvus client!");
        }
    }

    public boolean clientIsReady() {
        return this.channel != null && !this.channel.isShutdown() && !this.channel.isTerminated();
    }

    public void setBlockingStub(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub) {
        this.blockingStub = blockingStub;
    }
}

