/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import io.milvus.param.collection.CollectionSchemaParam;
import io.milvus.param.collection.FieldType;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class CreateCollectionParam {
    private final String collectionName;
    private final int shardsNum;
    private final String description;
    private final int partitionsNum;
    private final ConsistencyLevelEnum consistencyLevel;
    private final String databaseName;
    private final List<FieldType> fieldTypes;
    private final boolean enableDynamicField;

    private CreateCollectionParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.shardsNum = builder.shardsNum;
        this.description = builder.description;
        this.fieldTypes = builder.fieldTypes;
        this.partitionsNum = builder.partitionsNum;
        this.consistencyLevel = builder.consistencyLevel;
        this.databaseName = builder.databaseName;
        this.enableDynamicField = builder.enableDynamicField;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public int getShardsNum() {
        return this.shardsNum;
    }

    public String getDescription() {
        return this.description;
    }

    public int getPartitionsNum() {
        return this.partitionsNum;
    }

    public ConsistencyLevelEnum getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public List<FieldType> getFieldTypes() {
        return this.fieldTypes;
    }

    public boolean isEnableDynamicField() {
        return this.enableDynamicField;
    }

    public String toString() {
        return "CreateCollectionParam(collectionName=" + this.getCollectionName() + ", shardsNum=" + this.getShardsNum() + ", description=" + this.getDescription() + ", partitionsNum=" + this.getPartitionsNum() + ", consistencyLevel=" + (Object)((Object)this.getConsistencyLevel()) + ", databaseName=" + this.getDatabaseName() + ", fieldTypes=" + this.getFieldTypes() + ", enableDynamicField=" + this.isEnableDynamicField() + ")";
    }

    public static final class Builder {
        private String collectionName;
        private int shardsNum = 0;
        private String description = "";
        private List<FieldType> fieldTypes = new ArrayList<FieldType>();
        private int partitionsNum = 0;
        private ConsistencyLevelEnum consistencyLevel = ConsistencyLevelEnum.BOUNDED;
        private String databaseName;
        private CollectionSchemaParam schema;
        private boolean enableDynamicField;

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withShardsNum(int shardsNum) {
            this.shardsNum = shardsNum;
            return this;
        }

        @Deprecated
        public Builder withEnableDynamicField(boolean enableDynamicField) {
            this.enableDynamicField = enableDynamicField;
            return this;
        }

        public Builder withDescription(@NonNull String description) {
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            this.description = description;
            return this;
        }

        @Deprecated
        public Builder withFieldTypes(@NonNull List<FieldType> fieldTypes) {
            if (fieldTypes == null) {
                throw new NullPointerException("fieldTypes is marked non-null but is null");
            }
            this.fieldTypes.addAll(fieldTypes);
            return this;
        }

        @Deprecated
        public Builder addFieldType(@NonNull FieldType fieldType) {
            if (fieldType == null) {
                throw new NullPointerException("fieldType is marked non-null but is null");
            }
            this.fieldTypes.add(fieldType);
            return this;
        }

        public Builder withConsistencyLevel(@NonNull ConsistencyLevelEnum consistencyLevel) {
            if (consistencyLevel == null) {
                throw new NullPointerException("consistencyLevel is marked non-null but is null");
            }
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public Builder withPartitionsNum(int partitionsNum) {
            this.partitionsNum = partitionsNum;
            return this;
        }

        public Builder withSchema(@NonNull CollectionSchemaParam schema) {
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            this.schema = schema;
            return this;
        }

        public CreateCollectionParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (this.shardsNum < 0) {
                throw new ParamException("ShardNum must be larger or equal to 0");
            }
            if (!this.fieldTypes.isEmpty() && this.schema != null) {
                throw new ParamException("Please use either withFieldTypes(), addFieldType(), or withSchema(), and do not use them simultaneously.");
            }
            if (this.schema != null) {
                this.fieldTypes = this.schema.getFieldTypes();
                this.enableDynamicField = this.schema.isEnableDynamicField();
            }
            if (this.fieldTypes.isEmpty()) {
                throw new ParamException("Field numbers must be larger than 0");
            }
            boolean hasPartitionKey = false;
            for (FieldType fieldType : this.fieldTypes) {
                if (fieldType == null) {
                    throw new ParamException("Collection field cannot be null");
                }
                if (!fieldType.isPartitionKey()) continue;
                if (hasPartitionKey) {
                    throw new ParamException("Only one partition key field is allowed in a collection");
                }
                hasPartitionKey = true;
            }
            if (this.partitionsNum > 0 && !hasPartitionKey) {
                throw new ParamException("None of fields is partition key, not allow to define partition number");
            }
            return new CreateCollectionParam(this);
        }
    }
}

