/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter.writer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.milvus.bulkwriter.writer.FormatFileWriter;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONFileWriter
implements FormatFileWriter {
    private static final Logger logger = LoggerFactory.getLogger(JSONFileWriter.class);
    private BufferedWriter writer;
    private CreateCollectionReq.CollectionSchema collectionSchema;
    private String filePath;

    public JSONFileWriter(CreateCollectionReq.CollectionSchema collectionSchema, String filePathPrefix) throws IOException {
        this.collectionSchema = collectionSchema;
        this.initFilePath(filePathPrefix);
        this.initWriter();
    }

    private void initFilePath(String filePathPrefix) {
        this.filePath = filePathPrefix + ".json";
    }

    private void initWriter() throws IOException {
        this.writer = new BufferedWriter(new FileWriter(this.filePath));
    }

    @Override
    public void appendRow(Map<String, Object> rowValues, boolean firstWrite) throws IOException {
        Gson gson = new GsonBuilder().serializeNulls().create();
        rowValues.keySet().removeIf(key -> key.equals("$meta") && !this.collectionSchema.isEnableDynamicField());
        rowValues.replaceAll((key, value) -> value instanceof ByteBuffer ? (Object)((ByteBuffer)value).array() : value);
        try {
            if (firstWrite) {
                this.writer.write("[\n");
            } else {
                this.writer.write(",");
                this.writer.newLine();
            }
            String json = gson.toJson(rowValues);
            this.writer.write(json);
        }
        catch (IOException e) {
            logger.error("{} appendRow error when writing to file {}", new Object[]{this.getClass().getSimpleName(), this.filePath, e});
            throw e;
        }
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public void close() throws IOException {
        this.appendEnd();
        this.writer.close();
    }

    private void appendEnd() throws IOException {
        this.writer.newLine();
        this.writer.write("]\n");
    }
}

