/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter.storage.client;

import com.google.common.collect.Multimap;
import io.milvus.bulkwriter.common.clientenum.CloudStorage;
import io.milvus.bulkwriter.storage.StorageClient;
import io.minio.BucketExistsArgs;
import io.minio.MinioAsyncClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.credentials.Provider;
import io.minio.credentials.StaticProvider;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.XmlParserException;
import io.minio.http.Method;
import io.minio.messages.CompleteMultipartUpload;
import io.minio.messages.Part;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioStorageClient
extends MinioAsyncClient
implements StorageClient {
    private static final Logger logger = LoggerFactory.getLogger(MinioStorageClient.class);
    private static final String UPLOAD_ID = "uploadId";

    protected MinioStorageClient(MinioAsyncClient client) {
        super(client);
    }

    public static MinioStorageClient getStorageClient(String cloudName, String endpoint, String accessKey, String secretKey, String sessionToken, String region, OkHttpClient httpClient) {
        MinioAsyncClient.Builder minioClientBuilder = MinioAsyncClient.builder().endpoint(endpoint).credentialsProvider((Provider)new StaticProvider(accessKey, secretKey, sessionToken));
        if (StringUtils.isNotEmpty((CharSequence)region)) {
            minioClientBuilder.region(region);
        }
        if (httpClient != null) {
            minioClientBuilder.httpClient(httpClient);
        }
        MinioAsyncClient minioClient = minioClientBuilder.build();
        if (CloudStorage.isTcCloud(cloudName)) {
            minioClient.enableVirtualStyleEndpoint();
        }
        return new MinioStorageClient(minioClient);
    }

    @Override
    public Long getObjectEntity(String bucketName, String objectKey) throws Exception {
        StatObjectArgs statObjectArgs = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(objectKey)).build();
        StatObjectResponse statObject = (StatObjectResponse)this.statObject(statObjectArgs).get();
        return statObject.size();
    }

    @Override
    public void putObject(File file, String bucketName, String objectKey) throws Exception {
        logger.info("uploading file, fileName:{}, size:{} bytes", (Object)file.getAbsolutePath(), (Object)file.length());
        FileInputStream fileInputStream = new FileInputStream(file);
        PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectKey)).stream((InputStream)fileInputStream, file.length(), 0x500000L).build();
        this.putObject(putObjectArgs).get();
    }

    @Override
    public boolean checkBucketExist(String bucketName) throws Exception {
        BucketExistsArgs bucketExistsArgs = (BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build();
        return (Boolean)this.bucketExists(bucketExistsArgs).get();
    }

    protected CompletableFuture<ObjectWriteResponse> completeMultipartUploadAsync(String bucketName, String region, String objectName, String uploadId, Part[] parts, Multimap<String, String> extraHeaders, Multimap<String, String> extraQueryParams) throws InsufficientDataException, InternalException, InvalidKeyException, IOException, NoSuchAlgorithmException, XmlParserException {
        Multimap queryParams = this.newMultimap(extraQueryParams);
        queryParams.put((Object)UPLOAD_ID, (Object)uploadId);
        return ((CompletableFuture)this.getRegionAsync(bucketName, region).thenCompose(location -> {
            try {
                return this.executeAsync(Method.POST, bucketName, objectName, (String)location, this.httpHeaders(extraHeaders), queryParams, new CompleteMultipartUpload(parts), 0);
            }
            catch (InsufficientDataException | InternalException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                throw new CompletionException(e);
            }
        })).thenApply(response -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }
}

