/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter.restful;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.milvus.bulkwriter.request.stage.BaseStageRequest;
import io.milvus.bulkwriter.request.stage.CreateStageRequest;
import io.milvus.bulkwriter.request.stage.DeleteStageRequest;
import io.milvus.bulkwriter.request.stage.ListStagesRequest;
import io.milvus.bulkwriter.response.RestfulResponse;
import io.milvus.bulkwriter.restful.BaseRestful;
import io.milvus.common.utils.JsonUtils;
import java.lang.reflect.Type;
import java.util.Map;

public class DataStageUtils
extends BaseRestful {
    public static String applyStage(String url, BaseStageRequest request) {
        String requestURL = url + "/v2/stages/apply";
        Map params = (Map)JsonUtils.fromJson((String)JsonUtils.toJson((Object)request), (Type)new TypeToken<Map<String, Object>>(){}.getType());
        String body = DataStageUtils.postRequest(requestURL, request.getApiKey(), params, 60000);
        RestfulResponse response = (RestfulResponse)JsonUtils.fromJson((String)body, (Type)new TypeToken<RestfulResponse<Object>>(){}.getType());
        DataStageUtils.handleResponse(requestURL, response);
        return new Gson().toJson(response.getData());
    }

    public static String listStages(String url, String apiKey, ListStagesRequest request) {
        String requestURL = url + "/v2/stages";
        Map params = (Map)JsonUtils.fromJson((String)JsonUtils.toJson((Object)request), (Type)new TypeToken<Map<String, Object>>(){}.getType());
        String body = DataStageUtils.getRequest(requestURL, apiKey, params, 60000);
        RestfulResponse response = (RestfulResponse)JsonUtils.fromJson((String)body, (Type)new TypeToken<RestfulResponse<Object>>(){}.getType());
        DataStageUtils.handleResponse(requestURL, response);
        return new Gson().toJson(response.getData());
    }

    public static void createStage(String url, String apiKey, CreateStageRequest request) {
        String requestURL = url + "/v2/stages/create";
        Map params = (Map)JsonUtils.fromJson((String)JsonUtils.toJson((Object)request), (Type)new TypeToken<Map<String, Object>>(){}.getType());
        String body = DataStageUtils.postRequest(requestURL, apiKey, params, 60000);
        RestfulResponse response = (RestfulResponse)JsonUtils.fromJson((String)body, (Type)new TypeToken<RestfulResponse<Object>>(){}.getType());
        DataStageUtils.handleResponse(requestURL, response);
    }

    public static void deleteStage(String url, String apiKey, DeleteStageRequest request) {
        String requestURL = url + "/v2/stages/" + request.getStageName();
        Map params = (Map)JsonUtils.fromJson((String)JsonUtils.toJson((Object)request), (Type)new TypeToken<Map<String, Object>>(){}.getType());
        String body = DataStageUtils.deleteRequest(requestURL, apiKey, params, 60000);
        RestfulResponse response = (RestfulResponse)JsonUtils.fromJson((String)body, (Type)new TypeToken<RestfulResponse<Object>>(){}.getType());
        DataStageUtils.handleResponse(requestURL, response);
    }
}

