/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter.common.utils;

import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class FileUtils {
    public static Pair<List<String>, Long> processLocalPath(String localPath) {
        Path path = Paths.get(localPath, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Path does not exist: " + localPath);
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return Pair.of((Object)Lists.newArrayList((Object[])new String[]{path.toString()}), (Object)path.toFile().length());
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return FileUtils.findFilesRecursively(path.toFile());
        }
        return Pair.of(new ArrayList(), (Object)0L);
    }

    public static Pair<List<String>, Long> findFilesRecursively(File folder) {
        ArrayList<String> result = new ArrayList<String>();
        long totalSize = 0L;
        File[] entries = folder.listFiles();
        if (entries == null) {
            return Pair.of(result, (Object)0L);
        }
        for (File entry : entries) {
            if (entry.isFile()) {
                result.add(entry.getAbsolutePath());
                totalSize += entry.length();
                continue;
            }
            if (!entry.isDirectory()) continue;
            Pair<List<String>, Long> subResult = FileUtils.findFilesRecursively(entry);
            result.addAll((Collection)subResult.getLeft());
            totalSize += ((Long)subResult.getRight()).longValue();
        }
        return Pair.of(result, (Object)totalSize);
    }
}

