/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter;

import io.milvus.bulkwriter.common.clientenum.BulkFileType;
import io.milvus.bulkwriter.common.utils.V2AdapterUtils;
import io.milvus.bulkwriter.connect.StorageConnectParam;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import io.milvus.param.collection.CollectionSchemaParam;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public class RemoteBulkWriterParam {
    private final CreateCollectionReq.CollectionSchema collectionSchema;
    private final StorageConnectParam connectParam;
    private final String remotePath;
    private final long chunkSize;
    private final BulkFileType fileType;
    private final Map<String, Object> config;

    private RemoteBulkWriterParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionSchema = builder.collectionSchema;
        this.connectParam = builder.connectParam;
        this.remotePath = builder.remotePath;
        this.chunkSize = builder.chunkSize;
        this.fileType = builder.fileType;
        this.config = builder.config;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public CreateCollectionReq.CollectionSchema getCollectionSchema() {
        return this.collectionSchema;
    }

    public StorageConnectParam getConnectParam() {
        return this.connectParam;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public long getChunkSize() {
        return this.chunkSize;
    }

    public BulkFileType getFileType() {
        return this.fileType;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public String toString() {
        return "RemoteBulkWriterParam(collectionSchema=" + this.getCollectionSchema() + ", connectParam=" + this.getConnectParam() + ", remotePath=" + this.getRemotePath() + ", chunkSize=" + this.getChunkSize() + ", fileType=" + (Object)((Object)this.getFileType()) + ", config=" + this.getConfig() + ")";
    }

    public static final class Builder {
        private CreateCollectionReq.CollectionSchema collectionSchema;
        private StorageConnectParam connectParam;
        private String remotePath;
        private long chunkSize = 0x8000000L;
        private BulkFileType fileType = BulkFileType.PARQUET;
        private Map<String, Object> config = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder withCollectionSchema(@NonNull CollectionSchemaParam collectionSchema) {
            if (collectionSchema == null) {
                throw new NullPointerException("collectionSchema is marked non-null but is null");
            }
            this.collectionSchema = V2AdapterUtils.convertV1Schema(collectionSchema);
            return this;
        }

        public Builder withCollectionSchema(@NonNull CreateCollectionReq.CollectionSchema collectionSchema) {
            if (collectionSchema == null) {
                throw new NullPointerException("collectionSchema is marked non-null but is null");
            }
            this.collectionSchema = collectionSchema;
            return this;
        }

        public Builder withConnectParam(@NotNull StorageConnectParam connectParam) {
            this.connectParam = connectParam;
            return this;
        }

        public Builder withRemotePath(@NonNull String remotePath) {
            if (remotePath == null) {
                throw new NullPointerException("remotePath is marked non-null but is null");
            }
            this.remotePath = remotePath;
            return this;
        }

        public Builder withChunkSize(long chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public Builder withFileType(@NonNull BulkFileType fileType) {
            if (fileType == null) {
                throw new NullPointerException("fileType is marked non-null but is null");
            }
            this.fileType = fileType;
            return this;
        }

        public Builder withConfig(String key, Object val) {
            this.config.put(key, val);
            return this;
        }

        public RemoteBulkWriterParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString((String)this.remotePath, (String)"localPath");
            if (this.collectionSchema == null) {
                throw new ParamException("collectionSchema cannot be null");
            }
            if (this.connectParam == null) {
                throw new ParamException("connectParam cannot be null");
            }
            return new RemoteBulkWriterParam(this);
        }
    }
}

