/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter;

import io.milvus.bulkwriter.common.clientenum.BulkFileType;
import io.milvus.bulkwriter.common.utils.V2AdapterUtils;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import io.milvus.param.collection.CollectionSchemaParam;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class LocalBulkWriterParam {
    private final CreateCollectionReq.CollectionSchema collectionSchema;
    private final String localPath;
    private final long chunkSize;
    private final BulkFileType fileType;
    private final Map<String, Object> config;

    private LocalBulkWriterParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionSchema = builder.collectionSchema;
        this.localPath = builder.localPath;
        this.chunkSize = builder.chunkSize;
        this.fileType = builder.fileType;
        this.config = builder.config;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public CreateCollectionReq.CollectionSchema getCollectionSchema() {
        return this.collectionSchema;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public long getChunkSize() {
        return this.chunkSize;
    }

    public BulkFileType getFileType() {
        return this.fileType;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public String toString() {
        return "LocalBulkWriterParam(collectionSchema=" + this.getCollectionSchema() + ", localPath=" + this.getLocalPath() + ", chunkSize=" + this.getChunkSize() + ", fileType=" + (Object)((Object)this.getFileType()) + ", config=" + this.getConfig() + ")";
    }

    public static final class Builder {
        private CreateCollectionReq.CollectionSchema collectionSchema;
        private String localPath;
        private long chunkSize = 0x8000000L;
        private BulkFileType fileType = BulkFileType.PARQUET;
        private Map<String, Object> config = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder withCollectionSchema(@NonNull CollectionSchemaParam collectionSchema) {
            if (collectionSchema == null) {
                throw new NullPointerException("collectionSchema is marked non-null but is null");
            }
            this.collectionSchema = V2AdapterUtils.convertV1Schema(collectionSchema);
            return this;
        }

        public Builder withCollectionSchema(@NonNull CreateCollectionReq.CollectionSchema collectionSchema) {
            if (collectionSchema == null) {
                throw new NullPointerException("collectionSchema is marked non-null but is null");
            }
            this.collectionSchema = collectionSchema;
            return this;
        }

        public Builder withLocalPath(@NonNull String localPath) {
            if (localPath == null) {
                throw new NullPointerException("localPath is marked non-null but is null");
            }
            this.localPath = localPath;
            return this;
        }

        public Builder withChunkSize(long chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public Builder withFileType(BulkFileType fileType) {
            this.fileType = fileType;
            return this;
        }

        public Builder withConfig(String key, Object val) {
            this.config.put(key, val);
            return this;
        }

        public LocalBulkWriterParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString((String)this.localPath, (String)"localPath");
            if (this.collectionSchema == null) {
                throw new ParamException("collectionParam cannot be null");
            }
            return new LocalBulkWriterParam(this);
        }
    }
}

