/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.validation.validator.DefaultConstraintValidatorContext;
import io.micronaut.validation.validator.DefaultConstraintViolation;
import io.micronaut.validation.validator.ValidationPath;
import io.micronaut.validation.validator.messages.DefaultMessageInterpolatorContext;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.ElementKind;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Path;

@Internal
final class DefaultConstraintViolationBuilder<R>
implements ConstraintValidatorContext.ConstraintViolationBuilder {
    private final String messageTemplate;
    private final DefaultConstraintValidatorContext<R> constraintValidatorContext;
    private final MessageInterpolator messageInterpolator;
    private final ValidationPath validationPath;
    private final ConstraintValidatorContext.ConstraintViolationBuilder.ContainerElementNodeBuilderDefinedContext nodeBuilderDefinedContext = new DefaultContainerElementNodeBuilderDefinedContext();
    @Nullable
    private ValidationPath.MutableContainerContext next;

    DefaultConstraintViolationBuilder(String messageTemplate, DefaultConstraintValidatorContext<R> constraintValidatorContext, MessageInterpolator messageInterpolator) {
        ElementKind kind;
        this.messageTemplate = messageTemplate;
        this.constraintValidatorContext = constraintValidatorContext;
        this.messageInterpolator = messageInterpolator;
        this.validationPath = new ValidationPath(constraintValidatorContext.getCurrentPath());
        Path.Node last = this.validationPath.peekLast();
        ElementKind elementKind = kind = last == null ? null : last.getKind();
        if (kind == ElementKind.CROSS_PARAMETER) {
            this.validationPath.removeLast();
        }
        if (kind == ElementKind.BEAN) {
            Path.Node node = this.validationPath.removeLast();
            ValidationPath.DefaultNode defaultNode = (ValidationPath.DefaultNode)node;
            this.next = new ValidationPath.MutableContainerContext(defaultNode.containerContext);
        }
    }

    private ValidationPath.MutableContainerContext newMutableContainerContext() {
        if (this.next != null) {
            ValidationPath.MutableContainerContext c = this.next;
            this.next = null;
            return c;
        }
        return new ValidationPath.MutableContainerContext();
    }

    public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext addNode(String name) {
        this.addPropertyNode(name);
        return new DefaultNodeBuilderDefinedContext();
    }

    public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addPropertyNode(String name) {
        ValidationPath.MutableContainerContext containerContext = this.newMutableContainerContext();
        this.validationPath.addPropertyNode(name, containerContext);
        return new DefaultNodeBuilderCustomizableContext(containerContext);
    }

    public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext addBeanNode() {
        ValidationPath.MutableContainerContext containerContext = this.newMutableContainerContext();
        this.validationPath.addBeanNode(containerContext);
        return new DefaultLeafNodeBuilderCustomizableContext(containerContext);
    }

    public ConstraintValidatorContext.ConstraintViolationBuilder.ContainerElementNodeBuilderCustomizableContext addContainerElementNode(String name, Class<?> containerType, Integer typeArgumentIndex) {
        ValidationPath.MutableContainerContext containerContext = this.newMutableContainerContext();
        containerContext.inContainer(containerType, typeArgumentIndex);
        this.validationPath.addContainerElementNode(name, containerContext);
        return new DefaultContainerElementNodeBuilderCustomizableContext(containerContext);
    }

    public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext addParameterNode(int index) {
        Path.Node node = this.validationPath.peekLast();
        if (node == null || node.getKind() != ElementKind.METHOD) {
            throw new IllegalStateException("Cannot add parameter at path kind: " + String.valueOf(node == null ? "null" : node.getKind()));
        }
        String name = null;
        if (index != -1 && node instanceof ValidationPath.DefaultMethodNode) {
            ValidationPath.DefaultMethodNode methodNode = (ValidationPath.DefaultMethodNode)node;
            name = methodNode.getMethodReference().getArguments()[index].getName();
        }
        this.validationPath.addParameterNode(name, index);
        return new DefaultNodeBuilderDefinedContext();
    }

    public ConstraintValidatorContext addConstraintViolation() {
        this.constraintValidatorContext.addViolation(new DefaultConstraintViolation<R>(this.constraintValidatorContext.getRootBean(), this.constraintValidatorContext.getRootClass(), null, null, this.messageInterpolator.interpolate(this.messageTemplate, (MessageInterpolator.Context)new DefaultMessageInterpolatorContext(this.constraintValidatorContext, this.constraintValidatorContext.constraint, null)), this.messageTemplate, this.validationPath.iterator().hasNext() ? this.validationPath : new ValidationPath(this.constraintValidatorContext.getCurrentPath()), this.constraintValidatorContext.constraint, null, null));
        return this.constraintValidatorContext;
    }

    private final class DefaultContainerElementNodeBuilderDefinedContext
    implements ConstraintValidatorContext.ConstraintViolationBuilder.ContainerElementNodeBuilderDefinedContext {
        private DefaultContainerElementNodeBuilderDefinedContext() {
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addPropertyNode(String name) {
            return DefaultConstraintViolationBuilder.this.addPropertyNode(name);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext addBeanNode() {
            return DefaultConstraintViolationBuilder.this.addBeanNode();
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.ContainerElementNodeBuilderCustomizableContext addContainerElementNode(String name, Class<?> containerType, Integer typeArgumentIndex) {
            return DefaultConstraintViolationBuilder.this.addContainerElementNode(name, containerType, typeArgumentIndex);
        }

        public ConstraintValidatorContext addConstraintViolation() {
            return DefaultConstraintViolationBuilder.this.addConstraintViolation();
        }
    }

    private final class DefaultNodeBuilderDefinedContext
    implements ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext {
        private DefaultNodeBuilderDefinedContext() {
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addNode(String name) {
            return DefaultConstraintViolationBuilder.this.addPropertyNode(name);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addPropertyNode(String name) {
            return DefaultConstraintViolationBuilder.this.addPropertyNode(name);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext addBeanNode() {
            return DefaultConstraintViolationBuilder.this.addBeanNode();
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.ContainerElementNodeBuilderCustomizableContext addContainerElementNode(String name, Class<?> containerType, Integer typeArgumentIndex) {
            return DefaultConstraintViolationBuilder.this.addContainerElementNode(name, containerType, typeArgumentIndex);
        }

        public ConstraintValidatorContext addConstraintViolation() {
            return DefaultConstraintViolationBuilder.this.addConstraintViolation();
        }
    }

    private final class DefaultNodeBuilderCustomizableContext
    implements ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext {
        private final ValidationPath.MutableContainerContext containerContext;

        private DefaultNodeBuilderCustomizableContext(ValidationPath.MutableContainerContext containerContext) {
            this.containerContext = containerContext;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeContextBuilder inIterable() {
            this.containerContext.inIterable();
            return new DefaultNodeContextBuilder(this.containerContext);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext inContainer(Class<?> containerClass, Integer typeArgumentIndex) {
            this.containerContext.inContainer(containerClass, typeArgumentIndex);
            return this;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addNode(String name) {
            return DefaultConstraintViolationBuilder.this.addPropertyNode(name);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addPropertyNode(String name) {
            return DefaultConstraintViolationBuilder.this.addPropertyNode(name);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext addBeanNode() {
            return DefaultConstraintViolationBuilder.this.addBeanNode();
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.ContainerElementNodeBuilderCustomizableContext addContainerElementNode(String name, Class<?> containerType, Integer typeArgumentIndex) {
            return DefaultConstraintViolationBuilder.this.addContainerElementNode(name, containerType, typeArgumentIndex);
        }

        public ConstraintValidatorContext addConstraintViolation() {
            return DefaultConstraintViolationBuilder.this.addConstraintViolation();
        }
    }

    private final class DefaultLeafNodeBuilderCustomizableContext
    implements ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext {
        private final ValidationPath.MutableContainerContext containerContext;

        private DefaultLeafNodeBuilderCustomizableContext(ValidationPath.MutableContainerContext containerContext) {
            this.containerContext = containerContext;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeContextBuilder inIterable() {
            this.containerContext.inIterable();
            return new DefaultLeafNodeContextBuilder(this.containerContext);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext inContainer(Class<?> containerClass, Integer typeArgumentIndex) {
            this.containerContext.inContainer(containerClass, typeArgumentIndex);
            return new DefaultLeafNodeBuilderCustomizableContext(this.containerContext);
        }

        public ConstraintValidatorContext addConstraintViolation() {
            return DefaultConstraintViolationBuilder.this.addConstraintViolation();
        }
    }

    private final class DefaultContainerElementNodeBuilderCustomizableContext
    implements ConstraintValidatorContext.ConstraintViolationBuilder.ContainerElementNodeBuilderCustomizableContext {
        private final ValidationPath.MutableContainerContext containerContext;

        private DefaultContainerElementNodeBuilderCustomizableContext(ValidationPath.MutableContainerContext containerContext) {
            this.containerContext = containerContext;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.ContainerElementNodeContextBuilder inIterable() {
            this.containerContext.inIterable();
            return new DefaultContainerElementNodeContextBuilder(this.containerContext);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addPropertyNode(String name) {
            return DefaultConstraintViolationBuilder.this.addPropertyNode(name);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext addBeanNode() {
            return DefaultConstraintViolationBuilder.this.addBeanNode();
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.ContainerElementNodeBuilderCustomizableContext addContainerElementNode(String name, Class<?> containerType, Integer typeArgumentIndex) {
            return DefaultConstraintViolationBuilder.this.addContainerElementNode(name, containerType, typeArgumentIndex);
        }

        public ConstraintValidatorContext addConstraintViolation() {
            return DefaultConstraintViolationBuilder.this.addConstraintViolation();
        }
    }

    private final class DefaultLeafNodeContextBuilder
    implements ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeContextBuilder {
        private final ValidationPath.MutableContainerContext containerContext;

        private DefaultLeafNodeContextBuilder(ValidationPath.MutableContainerContext containerContext) {
            this.containerContext = containerContext;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderDefinedContext atKey(Object key) {
            this.containerContext.atKey(key);
            return DefaultConstraintViolationBuilder.this::addConstraintViolation;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderDefinedContext atIndex(Integer index) {
            this.containerContext.atIndex(index);
            return DefaultConstraintViolationBuilder.this::addConstraintViolation;
        }

        public ConstraintValidatorContext addConstraintViolation() {
            return DefaultConstraintViolationBuilder.this.addConstraintViolation();
        }
    }

    private final class DefaultNodeContextBuilder
    implements ConstraintValidatorContext.ConstraintViolationBuilder.NodeContextBuilder {
        private final ValidationPath.MutableContainerContext containerContext;

        private DefaultNodeContextBuilder(ValidationPath.MutableContainerContext containerContext) {
            this.containerContext = containerContext;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext atKey(Object key) {
            this.containerContext.atKey(key);
            return new DefaultNodeBuilderDefinedContext();
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext atIndex(Integer index) {
            this.containerContext.atIndex(index);
            return new DefaultNodeBuilderDefinedContext();
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addNode(String name) {
            return DefaultConstraintViolationBuilder.this.addPropertyNode(name);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addPropertyNode(String name) {
            return DefaultConstraintViolationBuilder.this.addPropertyNode(name);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext addBeanNode() {
            return DefaultConstraintViolationBuilder.this.addBeanNode();
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.ContainerElementNodeBuilderCustomizableContext addContainerElementNode(String name, Class<?> containerType, Integer typeArgumentIndex) {
            return DefaultConstraintViolationBuilder.this.addContainerElementNode(name, containerType, typeArgumentIndex);
        }

        public ConstraintValidatorContext addConstraintViolation() {
            return DefaultConstraintViolationBuilder.this.addConstraintViolation();
        }
    }

    private final class DefaultContainerElementNodeContextBuilder
    implements ConstraintValidatorContext.ConstraintViolationBuilder.ContainerElementNodeContextBuilder {
        private final ValidationPath.MutableContainerContext containerContext;

        private DefaultContainerElementNodeContextBuilder(ValidationPath.MutableContainerContext containerContext) {
            this.containerContext = containerContext;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.ContainerElementNodeBuilderDefinedContext atKey(Object key) {
            this.containerContext.atKey(key);
            return DefaultConstraintViolationBuilder.this.nodeBuilderDefinedContext;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.ContainerElementNodeBuilderDefinedContext atIndex(Integer index) {
            this.containerContext.atIndex(index);
            return DefaultConstraintViolationBuilder.this.nodeBuilderDefinedContext;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addPropertyNode(String name) {
            return DefaultConstraintViolationBuilder.this.addPropertyNode(name);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext addBeanNode() {
            return DefaultConstraintViolationBuilder.this.addBeanNode();
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.ContainerElementNodeBuilderCustomizableContext addContainerElementNode(String name, Class<?> containerType, Integer typeArgumentIndex) {
            return DefaultConstraintViolationBuilder.this.addContainerElementNode(name, containerType, typeArgumentIndex);
        }

        public ConstraintValidatorContext addConstraintViolation() {
            return DefaultConstraintViolationBuilder.this.addConstraintViolation();
        }
    }
}

