/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.messages;

import io.micronaut.context.StaticMessageSource;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import jakarta.validation.constraints.AssertFalse;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.Future;
import jakarta.validation.constraints.FutureOrPresent;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Negative;
import jakarta.validation.constraints.NegativeOrZero;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import jakarta.validation.constraints.Past;
import jakarta.validation.constraints.PastOrPresent;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;

@Internal
@Prototype
public final class DefaultMessages
extends StaticMessageSource {
    private static final String MESSAGE_SUFFIX = ".message";

    public DefaultMessages() {
        this.addMessage(AssertTrue.class.getName() + MESSAGE_SUFFIX, "must be true");
        this.addMessage(AssertFalse.class.getName() + MESSAGE_SUFFIX, "must be false");
        this.addMessage(DecimalMax.class.getName() + MESSAGE_SUFFIX, "must be less than or equal to {value}");
        this.addMessage(DecimalMin.class.getName() + MESSAGE_SUFFIX, "must be greater than or equal to {value}");
        this.addMessage(Digits.class.getName() + MESSAGE_SUFFIX, "numeric value out of bounds (<{integer} digits>.<{fraction} digits> expected)");
        this.addMessage(Email.class.getName() + MESSAGE_SUFFIX, "must be a well-formed email address");
        this.addMessage(Future.class.getName() + MESSAGE_SUFFIX, "must be a future date");
        this.addMessage(FutureOrPresent.class.getName() + MESSAGE_SUFFIX, "must be a date in the present or in the future");
        this.addMessage(Max.class.getName() + MESSAGE_SUFFIX, "must be less than or equal to {value}");
        this.addMessage(Min.class.getName() + MESSAGE_SUFFIX, "must be greater than or equal to {value}");
        this.addMessage(Negative.class.getName() + MESSAGE_SUFFIX, "must be less than 0");
        this.addMessage(NegativeOrZero.class.getName() + MESSAGE_SUFFIX, "must be less than or equal to 0");
        this.addMessage(NotBlank.class.getName() + MESSAGE_SUFFIX, "must not be blank");
        this.addMessage(NotEmpty.class.getName() + MESSAGE_SUFFIX, "must not be empty");
        this.addMessage(NotNull.class.getName() + MESSAGE_SUFFIX, "must not be null");
        this.addMessage(Null.class.getName() + MESSAGE_SUFFIX, "must be null");
        this.addMessage(Past.class.getName() + MESSAGE_SUFFIX, "must be a past date");
        this.addMessage(PastOrPresent.class.getName() + MESSAGE_SUFFIX, "must be a date in the past or in the present");
        this.addMessage(Pattern.class.getName() + MESSAGE_SUFFIX, "must match \"{regexp}\"");
        this.addMessage(Positive.class.getName() + MESSAGE_SUFFIX, "must be greater than 0");
        this.addMessage(PositiveOrZero.class.getName() + MESSAGE_SUFFIX, "must be greater than or equal to 0");
        this.addMessage(Size.class.getName() + MESSAGE_SUFFIX, "size must be between {min} and {max}");
        this.addMessage(Introspected.class.getName() + MESSAGE_SUFFIX, "Cannot validate {type}. No bean introspection present. Please add @Introspected to the class and ensure Micronaut annotation processing is enabled");
    }
}

