/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.validation.validator.DefaultConstraintDescriptor;
import jakarta.validation.Constraint;
import jakarta.validation.Valid;
import jakarta.validation.metadata.BeanDescriptor;
import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.validation.metadata.ConstructorDescriptor;
import jakarta.validation.metadata.ContainerElementTypeDescriptor;
import jakarta.validation.metadata.ElementDescriptor;
import jakarta.validation.metadata.GroupConversionDescriptor;
import jakarta.validation.metadata.MethodDescriptor;
import jakarta.validation.metadata.MethodType;
import jakarta.validation.metadata.PropertyDescriptor;
import jakarta.validation.metadata.Scope;
import java.lang.annotation.ElementType;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

@Internal
class IntrospectedBeanDescriptor
implements BeanDescriptor,
ElementDescriptor.ConstraintFinder {
    private final BeanIntrospection<?> beanIntrospection;

    IntrospectedBeanDescriptor(BeanIntrospection<?> beanIntrospection) {
        ArgumentUtils.requireNonNull((String)"beanIntrospection", beanIntrospection);
        this.beanIntrospection = beanIntrospection;
    }

    public boolean isBeanConstrained() {
        return this.hasConstraints();
    }

    public PropertyDescriptor getConstraintsForProperty(String propertyName) {
        return this.beanIntrospection.getProperty(propertyName).map(x$0 -> new IntrospectedPropertyDescriptor((BeanProperty<?, ?>)x$0)).orElse(null);
    }

    public Set<PropertyDescriptor> getConstrainedProperties() {
        return this.beanIntrospection.getIndexedProperties(Constraint.class).stream().map(x$0 -> new IntrospectedPropertyDescriptor((BeanProperty<?, ?>)x$0)).collect(Collectors.toSet());
    }

    public MethodDescriptor getConstraintsForMethod(String methodName, Class<?> ... parameterTypes) {
        return null;
    }

    public Set<MethodDescriptor> getConstrainedMethods(MethodType methodType, MethodType ... methodTypes) {
        return Collections.emptySet();
    }

    public ConstructorDescriptor getConstraintsForConstructor(Class<?> ... parameterTypes) {
        return null;
    }

    public Set<ConstructorDescriptor> getConstrainedConstructors() {
        return Collections.emptySet();
    }

    public boolean hasConstraints() {
        return this.beanIntrospection.getIndexedProperty(Constraint.class).isPresent();
    }

    public Class<?> getElementClass() {
        return this.beanIntrospection.getBeanType();
    }

    public ElementDescriptor.ConstraintFinder unorderedAndMatchingGroups(Class<?> ... groups) {
        return this;
    }

    public ElementDescriptor.ConstraintFinder lookingAt(Scope scope) {
        return this;
    }

    public ElementDescriptor.ConstraintFinder declaredOn(ElementType ... types) {
        return this;
    }

    public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
        return Collections.emptySet();
    }

    public ElementDescriptor.ConstraintFinder findConstraints() {
        return this;
    }

    private final class IntrospectedPropertyDescriptor
    implements PropertyDescriptor,
    ElementDescriptor.ConstraintFinder {
        private final BeanProperty<?, ?> beanProperty;

        IntrospectedPropertyDescriptor(BeanProperty<?, ?> beanProperty) {
            this.beanProperty = beanProperty;
        }

        public String getPropertyName() {
            return this.beanProperty.getName();
        }

        public boolean isCascaded() {
            return this.beanProperty.hasAnnotation(Valid.class);
        }

        public Set<GroupConversionDescriptor> getGroupConversions() {
            return Collections.emptySet();
        }

        public Set<ContainerElementTypeDescriptor> getConstrainedContainerElementTypes() {
            return Collections.emptySet();
        }

        public boolean hasConstraints() {
            return this.beanProperty.hasStereotype(Constraint.class);
        }

        public Class<?> getElementClass() {
            return this.beanProperty.getType();
        }

        public ElementDescriptor.ConstraintFinder unorderedAndMatchingGroups(Class<?> ... groups) {
            return this;
        }

        public ElementDescriptor.ConstraintFinder lookingAt(Scope scope) {
            return this;
        }

        public ElementDescriptor.ConstraintFinder declaredOn(ElementType ... types) {
            return this;
        }

        public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
            return this.beanProperty.getAnnotationTypesByStereotype(Constraint.class).stream().flatMap(type -> this.beanProperty.getAnnotationValuesByType(type).stream().map(annotationValue -> {
                AnnotationValue annotation = this.beanProperty.getAnnotation(type);
                return new DefaultConstraintDescriptor(type, annotation, (AnnotationMetadata)this.beanProperty);
            })).collect(Collectors.toSet());
        }

        public ElementDescriptor.ConstraintFinder findConstraints() {
            return this;
        }
    }
}

