/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.visitor;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Vetoed;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.validation.RequiresValidation;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Set;

@Internal
public class ValidationVisitor
implements TypeElementVisitor<Object, Object> {
    private static final String ANN_CASCADE = "io.micronaut.validation.annotation.ValidatedElement";
    private static final String ANN_CONSTRAINT = "jakarta.validation.Constraint";
    private static final String ANN_VALID = "jakarta.validation.Valid";
    private ClassElement classElement;

    public Set<String> getSupportedAnnotationNames() {
        return Set.of("jakarta.validation.*");
    }

    public int getOrder() {
        return 10;
    }

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        this.classElement = element;
        if (this.classElement.isInterface() && this.classElement.hasAnnotation("jakarta.validation.GroupSequence")) {
            this.classElement.annotate(Introspected.class);
        }
        this.classElement.getMethods().forEach(this::visitMethodInternal);
        this.classElement.getFields().forEach(this::visitFieldInternal);
    }

    public void visitConstructor(ConstructorElement element, VisitorContext context) {
        if (this.classElement == null) {
            return;
        }
        boolean parametersRequireValidation = this.parametersRequireValidation((MethodElement)element, true);
        boolean returnTypeRequiresValidation = this.visitElementValidationAndMarkForValidationIfNeeded((TypedElement)element.getReturnType(), true);
        if (returnTypeRequiresValidation || parametersRequireValidation) {
            element.annotate(RequiresValidation.class);
            this.classElement.annotate(RequiresValidation.class);
        }
    }

    private void visitMethodInternal(MethodElement element) {
        if (this.classElement == null || element.hasStereotype(Vetoed.class)) {
            return;
        }
        boolean isPrivate = element.isPrivate();
        boolean isAbstract = element.getOwningType().isInterface() || element.getOwningType().isAbstract();
        boolean requireOnConstraint = isAbstract || !isPrivate;
        boolean parametersRequireValidation = this.parametersRequireValidation(element, requireOnConstraint);
        boolean returnTypeRequiresValidation = this.visitElementValidationAndMarkForValidationIfNeeded((TypedElement)element.getReturnType(), requireOnConstraint);
        boolean methodAnnotatedForValidation = this.returnTypeRequiresValidation(element, true);
        if (parametersRequireValidation || returnTypeRequiresValidation || methodAnnotatedForValidation) {
            if (isPrivate) {
                throw new ProcessingException((Element)element, "Method annotated for validation but is declared private. Change the method to be non-private in order for AOP advice to be applied.");
            }
            element.annotate(RequiresValidation.class);
            this.classElement.annotate(RequiresValidation.class);
        }
    }

    private void visitFieldInternal(FieldElement element) {
        if (this.classElement == null) {
            return;
        }
        if (this.visitElementValidationAndMarkForValidationIfNeeded((TypedElement)element, true)) {
            element.annotate(RequiresValidation.class);
            this.classElement.annotate(RequiresValidation.class);
        }
    }

    private boolean parametersRequireValidation(MethodElement element, boolean requireOnConstraint) {
        boolean requiredValidation = false;
        for (ParameterElement parameter : element.getParameters()) {
            boolean requiresValidationForParameter = this.visitElementValidationAndMarkForValidationIfNeeded((TypedElement)parameter, requireOnConstraint);
            requiredValidation |= requiresValidationForParameter;
        }
        return requiredValidation;
    }

    private boolean returnTypeRequiresValidation(MethodElement e, boolean requireOnConstraint) {
        return e.hasStereotype(ANN_VALID) || requireOnConstraint && e.hasStereotype(ANN_CONSTRAINT);
    }

    private boolean visitElementValidationAndMarkForValidationIfNeeded(TypedElement e, boolean requireOnConstraint) {
        boolean requiresValidation;
        AnnotationMetadata annotationMetadata;
        boolean requiresTypeValidation = this.visitTypedElementValidationAndMarkForValidationIfNeeded(e, requireOnConstraint);
        if (e instanceof ClassElement) {
            ClassElement ce = (ClassElement)e;
            annotationMetadata = ce.getTypeAnnotationMetadata();
        } else {
            annotationMetadata = e.getAnnotationMetadata();
        }
        AnnotationMetadata annotationMetadata2 = annotationMetadata;
        boolean bl = requiresValidation = requireOnConstraint && annotationMetadata2.hasStereotype(ANN_CONSTRAINT) || annotationMetadata2.hasStereotype(ANN_VALID) || requiresTypeValidation;
        if (requiresValidation) {
            try {
                e.annotate(ANN_CASCADE);
                e.annotate(RequiresValidation.class);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return requiresValidation;
    }

    private boolean visitTypedElementValidationAndMarkForValidationIfNeeded(TypedElement e, boolean requireOnConstraint) {
        boolean requires = false;
        ClassElement genericType = e.getGenericType();
        for (ClassElement typeArgument : genericType.getTypeArguments().values()) {
            boolean requiresForType = this.visitElementValidationAndMarkForValidationIfNeeded((TypedElement)typeArgument, requireOnConstraint);
            requires |= requiresForType;
        }
        if (!genericType.equals(e)) {
            requires |= this.visitElementValidationAndMarkForValidationIfNeeded((TypedElement)genericType, requireOnConstraint);
        }
        return requires;
    }
}

