/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.transformer;

import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.inject.annotation.AnnotationRemapper;
import io.micronaut.inject.visitor.VisitorContext;
import jakarta.validation.Constraint;
import jakarta.validation.Valid;
import java.lang.annotation.Inherited;
import java.util.List;
import java.util.Optional;

public class ValidationAnnotationRemapper
implements AnnotationRemapper {
    public String getPackageName() {
        return "*";
    }

    public List<AnnotationValue<?>> remap(AnnotationValue<?> annotation, VisitorContext visitorContext) {
        Optional<AnnotationValue> optionalConstraint;
        if (annotation.getAnnotationName().equals(Valid.class.getName())) {
            return List.of(annotation.mutate().stereotype(AnnotationValue.builder(Inherited.class).build()).build());
        }
        List stereotypes = annotation.getStereotypes();
        if (stereotypes != null && (optionalConstraint = stereotypes.stream().filter(stereotype -> stereotype.getAnnotationName().equals(Constraint.class.getName())).findFirst()).isPresent()) {
            AnnotationValue constraintAnnotationValue = optionalConstraint.get();
            AnnotationValueBuilder builder = annotation.mutate();
            AnnotationClassValue[] validatedBy = constraintAnnotationValue.annotationClassValues("validatedBy");
            if (validatedBy.length > 0) {
                builder = builder.member("$validatedBy", validatedBy);
            }
            return List.of(builder.stereotype(AnnotationValue.builder(Inherited.class).build()).build());
        }
        return List.of(annotation);
    }
}

