/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.wait.strategy;

import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.TimeoutException;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;

public class ShellStrategy
extends AbstractWaitStrategy {
    private String command;

    public ShellStrategy withCommand(String command) {
        this.command = command;
        return this;
    }

    @Override
    protected void waitUntilReady() {
        try {
            Unreliables.retryUntilTrue((int)this.startupTimeout.getSeconds(), TimeUnit.SECONDS, () -> this.waitStrategyTarget.execInContainer("/bin/sh", "-c", this.command).getExitCode() == 0);
        }
        catch (TimeoutException e) {
            throw new ContainerLaunchException("Timed out waiting for container to execute `" + this.command + "` successfully.");
        }
    }
}

