/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.util;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;

@Internal
public final class BinaryCodecUtil {
    private static final Argument<byte[]> BYTE_ARRAY = Argument.of(byte[].class);

    private BinaryCodecUtil() {
    }

    public static byte[] decodeFromArray(Decoder base) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try (Decoder arrayDecoder = base.decodeArray(BYTE_ARRAY);){
            while (arrayDecoder.hasNextArrayValue()) {
                Byte b = arrayDecoder.decodeByteNullable();
                buffer.write(b == null ? (byte)0 : b);
            }
        }
        return buffer.toByteArray();
    }

    public static byte[] decodeFromBase64String(Decoder base) throws IOException {
        String s2 = base.decodeString();
        try {
            return Base64.getDecoder().decode(s2);
        }
        catch (IllegalArgumentException e) {
            throw base.createDeserializationException("Illegal base64 input: " + e.getMessage(), null);
        }
    }

    public static void encodeToArray(Encoder encoder, byte[] data) throws IOException {
        try (Encoder arrayEncoder = encoder.encodeArray(BYTE_ARRAY);){
            for (byte i : data) {
                arrayEncoder.encodeByte(i);
            }
        }
    }

    public static void encodeToBase64String(Encoder encoder, byte[] data) throws IOException {
        encoder.encodeString(Base64.getEncoder().encodeToString(data));
    }
}

