/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.util;

import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.support.util.JsonNodeDecoder;
import java.util.Iterator;
import java.util.Map;

final class JsonObjectNodeDecoder
extends JsonNodeDecoder {
    private final Iterator<Map.Entry<String, JsonNode>> iterator;
    private JsonNode nextValue = null;

    JsonObjectNodeDecoder(JsonNode node, LimitingStream.RemainingLimits remainingLimits) {
        super(remainingLimits);
        this.iterator = node.entries().iterator();
    }

    @Override
    protected JsonNode peekValue() {
        if (this.nextValue == null) {
            throw new IllegalStateException("Field name not parsed yet");
        }
        return this.nextValue;
    }

    @Override
    public void skipValue() {
        if (this.nextValue == null) {
            throw new IllegalStateException("Field name not parsed yet");
        }
        this.nextValue = null;
    }

    @Override
    public boolean hasNextArrayValue() {
        return false;
    }

    @Override
    public String decodeKey() {
        if (this.nextValue != null) {
            throw new IllegalStateException("Field value not parsed yet");
        }
        if (this.iterator.hasNext()) {
            Map.Entry<String, JsonNode> next = this.iterator.next();
            this.nextValue = next.getValue();
            return next.getKey();
        }
        return null;
    }

    @Override
    public void finishStructure(boolean consumeLeftElements) {
        if (!consumeLeftElements && (this.nextValue != null || this.iterator.hasNext())) {
            throw new IllegalStateException("Not all elements have been consumed yet");
        }
    }
}

