/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.util.Arrays;

@Internal
final class StringArraySerde
implements SerdeRegistrar<String[]> {
    StringArraySerde() {
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends String[]> type, String[] strings) throws IOException {
        Encoder arrayEncoder = encoder.encodeArray(type);
        for (String string : strings) {
            arrayEncoder.encodeString(string);
        }
        arrayEncoder.finishStructure();
    }

    @Override
    public String[] deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super String[]> type) throws IOException {
        Decoder arrayDecoder = decoder.decodeArray();
        String[] buffer = new String[50];
        int index = 0;
        while (arrayDecoder.hasNextArrayValue()) {
            int l = buffer.length;
            if (l == index) {
                buffer = Arrays.copyOf(buffer, l * 2);
            }
            buffer[index++] = arrayDecoder.decodeStringNullable();
        }
        arrayDecoder.finishStructure();
        return Arrays.copyOf(buffer, index);
    }

    @Override
    public boolean isEmpty(Serializer.EncoderContext context, String[] strings) {
        return strings == null || strings.length == 0;
    }

    @Override
    public Argument<String[]> getType() {
        return Argument.of(String[].class);
    }
}

