/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.support.serdes.NumberSerde;
import java.io.IOException;
import java.util.Arrays;

@Internal
final class IntegerSerde
implements SerdeRegistrar<Integer>,
NumberSerde<Integer> {
    IntegerSerde() {
    }

    @Override
    public Integer deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Integer> type) throws IOException {
        return decoder.decodeInt();
    }

    @Override
    public Integer deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Integer> type) throws IOException {
        return decoder.decodeIntNullable();
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Integer> type, Integer value) throws IOException {
        encoder.encodeInt(value);
    }

    @Override
    public Argument<Integer> getType() {
        return Argument.of(Integer.class);
    }

    @Override
    public Iterable<Argument<?>> getTypes() {
        return Arrays.asList(this.getType(), Argument.INT);
    }

    @Override
    @Nullable
    public Integer getDefaultValue(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Integer> type) {
        return type.isPrimitive() ? Integer.valueOf(0) : null;
    }
}

