/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.net.InetAddress;

public class InetAddressSerde
implements SerdeRegistrar<InetAddress> {
    private final boolean asNumeric;

    public InetAddressSerde(SerdeConfiguration serdeConfiguration) {
        this.asNumeric = serdeConfiguration.isInetAddressAsNumeric();
    }

    @Override
    @NonNull
    public Deserializer<InetAddress> createSpecific(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super InetAddress> type) throws SerdeException {
        return context.getSerdeConfiguration().map(InetAddressSerde::new).orElse(this);
    }

    @Override
    @NonNull
    public Serializer<InetAddress> createSpecific(@NonNull Serializer.EncoderContext context, @NonNull Argument<? extends InetAddress> type) throws SerdeException {
        return context.getSerdeConfiguration().map(InetAddressSerde::new).orElse(this);
    }

    @Override
    @Nullable
    public InetAddress deserialize(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super InetAddress> type) throws IOException {
        return InetAddress.getByName(decoder.decodeString());
    }

    @Override
    public void serialize(@NonNull Encoder encoder, @NonNull Serializer.EncoderContext context, @NonNull Argument<? extends InetAddress> type, @NonNull InetAddress value) throws IOException {
        String str;
        if (this.asNumeric) {
            str = value.getHostAddress();
        } else {
            str = value.toString().trim();
            int ix = str.indexOf(47);
            if (ix >= 0) {
                str = ix == 0 ? str.substring(1) : str.substring(0, ix);
            }
        }
        encoder.encodeString(str);
    }

    @Override
    public Argument<InetAddress> getType() {
        return Argument.of(InetAddress.class);
    }
}

