/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.support.serdes.NumberSerde;
import java.io.IOException;
import java.math.BigInteger;

@Internal
final class BigIntegerSerde
implements SerdeRegistrar<BigInteger>,
NumberSerde<BigInteger> {
    BigIntegerSerde() {
    }

    @Override
    public Argument<BigInteger> getType() {
        return Argument.of(BigInteger.class);
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends BigInteger> type, BigInteger value) throws IOException {
        encoder.encodeBigInteger(value);
    }

    @Override
    public BigInteger deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super BigInteger> type) throws IOException {
        return decoder.decodeBigInteger();
    }

    @Override
    public BigInteger deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super BigInteger> type) throws IOException {
        return decoder.decodeBigIntegerNullable();
    }
}

