/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers.collect;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.DeserializerRegistrar;
import java.io.IOException;
import java.util.EnumSet;

@Internal
final class EnumSetDeserializer<E extends Enum<E>>
implements DeserializerRegistrar<EnumSet<E>> {
    EnumSetDeserializer() {
    }

    @Override
    public EnumSet<E> deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super EnumSet<E>> type) throws IOException {
        Object[] generics = type.getTypeParameters();
        if (ArrayUtils.isEmpty(generics)) {
            throw new SerdeException("Cannot deserialize raw EnumSet");
        }
        Object generic2 = generics[0];
        Decoder arrayDecoder = decoder.decodeArray();
        Class enumType = generic2.getType();
        EnumSet enumSet = EnumSet.noneOf(enumType);
        while (arrayDecoder.hasNextArrayValue()) {
            enumSet.add(Enum.valueOf(enumType, arrayDecoder.decodeString()));
        }
        arrayDecoder.finishStructure();
        return enumSet;
    }

    @Override
    public Argument<EnumSet<E>> getType() {
        return Argument.of(EnumSet.class, Argument.ofTypeVariable(Enum.class, "E"));
    }
}

