/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.SerdeException;
import java.io.IOException;

@Internal
final class WrappedObjectDeserializer
implements Deserializer<Object> {
    private final Deserializer<Object> deserializer;
    private final String wrapperProperty;
    private final boolean ignoreUnknown;

    WrappedObjectDeserializer(Deserializer<Object> deserializer, String wrapperProperty, boolean ignoreUnknown) {
        this.deserializer = deserializer;
        this.wrapperProperty = wrapperProperty;
        this.ignoreUnknown = ignoreUnknown;
    }

    @Override
    public Object deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super Object> type) throws IOException {
        return this.deserialize(decoder, context, type, false);
    }

    @Override
    public Object deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Object> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, type, true);
    }

    private Object deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super Object> type, boolean isNullable) throws IOException {
        Decoder unwrappedDecoder = decoder.decodeObject();
        String key = unwrappedDecoder.decodeKey();
        if (key == null) {
            if (isNullable) {
                return null;
            }
            throw new SerdeException("Null wrapper property [" + this.wrapperProperty + "] encountered during deserialization of type: " + type);
        }
        if (!key.equals(this.wrapperProperty)) {
            throw this.unknownProperty(type, key);
        }
        Object result = isNullable ? this.deserializer.deserializeNullable(unwrappedDecoder, context, type) : this.deserializer.deserialize(unwrappedDecoder, context, type);
        if (this.ignoreUnknown) {
            unwrappedDecoder.finishStructure(true);
        } else {
            String unknownProp = unwrappedDecoder.decodeKey();
            if (unknownProp != null) {
                throw this.unknownProperty(type, unknownProp);
            }
            unwrappedDecoder.finishStructure();
        }
        return result;
    }

    private SerdeException unknownProperty(Argument<? super Object> beanType, String prop) {
        return new SerdeException("Unknown property [" + prop + "] encountered during deserialization of type: " + beanType);
    }
}

