/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.filter.FilterRunner;
import io.micronaut.http.filter.GenericHttpFilter;
import io.micronaut.http.server.ExecutableRouteInfo;
import io.micronaut.http.server.RouteExecutor;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.types.files.FileCustomizableResponseType;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.json.JsonSyntaxException;
import io.micronaut.web.router.DefaultRouteInfo;
import io.micronaut.web.router.RouteInfo;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.UriRouteMatch;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class RequestLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(RequestLifecycle.class);
    private final RouteExecutor routeExecutor;
    private final boolean multipartEnabled;
    private HttpRequest<?> request;

    protected RequestLifecycle(RouteExecutor routeExecutor) {
        this.routeExecutor = Objects.requireNonNull(routeExecutor, "routeExecutor");
        Optional<Boolean> isMultiPartEnabled = routeExecutor.serverConfiguration.getMultipart().getEnabled();
        this.multipartEnabled = isMultiPartEnabled.isEmpty() || isMultiPartEnabled.get() != false;
    }

    @Deprecated(forRemoval=true, since="4.3.0")
    protected RequestLifecycle(RouteExecutor routeExecutor, HttpRequest<?> request) {
        this(routeExecutor);
        this.request = request;
    }

    @Deprecated(forRemoval=true, since="4.3.0")
    protected final ExecutionFlow<HttpResponse<?>> normalFlow() {
        return this.normalFlow(this.request);
    }

    @Deprecated(forRemoval=true, since="4.3.0")
    protected final HttpRequest<?> request() {
        return this.request;
    }

    @Deprecated(forRemoval=true, since="4.3.0")
    @Nullable
    protected FileCustomizableResponseType findFile() {
        return null;
    }

    protected final ExecutionFlow<HttpResponse<?>> normalFlow(HttpRequest<?> request) {
        try {
            MediaType contentType;
            Objects.requireNonNull(request, "request");
            if (!this.multipartEnabled && (contentType = (MediaType)request.getContentType().orElse(null)) != null && contentType.equals(MediaType.MULTIPART_FORM_DATA_TYPE)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Multipart uploads have been disabled via configuration. Rejected request for URI {}, method {}, and content type {}", request.getUri(), request.getMethodName(), contentType);
                }
                return this.onStatusError(request, HttpResponse.status(HttpStatus.UNSUPPORTED_MEDIA_TYPE), "Content Type [" + contentType + "] not allowed");
            }
            UriRouteMatch<Object, Object> routeMatch = this.routeExecutor.findRouteMatch(request);
            if (routeMatch == null) {
                FileCustomizableResponseType fileCustomizableResponseType = this.findFile(request);
                if (fileCustomizableResponseType != null) {
                    return this.runWithFilters(request, (filteredRequest, propagatedContext) -> ExecutionFlow.just(HttpResponse.ok(fileCustomizableResponseType)));
                }
                return this.onRouteMiss(request);
            }
            RouteExecutor.setRouteAttributes(request, routeMatch);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Matched route {} - {} to controller {}", request.getMethodName(), request.getUri().getPath(), routeMatch.getDeclaringType());
            }
            if (routeMatch.getRouteInfo().isWebSocketRoute()) {
                return this.onStatusError(request, HttpResponse.status(HttpStatus.BAD_REQUEST), "Not a WebSocket request");
            }
            return this.runWithFilters(request, (filteredRequest, propagatedContext) -> this.executeRoute((HttpRequest<?>)filteredRequest, (PropagatedContext)propagatedContext, (RouteMatch<Object>)routeMatch));
        }
        catch (Throwable t2) {
            return this.onError(request, t2);
        }
    }

    private ExecutionFlow<HttpResponse<?>> executeRoute(HttpRequest<?> request, PropagatedContext propagatedContext, RouteMatch<Object> routeMatch) {
        ExecutionFlow<RouteMatch<?>> routeMatchFlow = this.fulfillArguments(routeMatch, request);
        ExecutionFlow<HttpResponse<?>> responseFlow = this.callRoute(routeMatchFlow, request, propagatedContext);
        responseFlow = this.handleStatusException(responseFlow, request, routeMatch, propagatedContext);
        return this.onErrorNoFilter(responseFlow, request, propagatedContext);
    }

    private ExecutionFlow<HttpResponse<?>> callRoute(ExecutionFlow<RouteMatch<?>> flux, HttpRequest<?> filteredRequest, PropagatedContext propagatedContext) {
        RouteMatch<?> routeMatch = flux.tryCompleteValue();
        if (routeMatch != null) {
            return this.routeExecutor.callRoute(propagatedContext, routeMatch, filteredRequest);
        }
        return flux.flatMap(rm -> this.routeExecutor.callRoute(propagatedContext, (RouteMatch<?>)rm, filteredRequest));
    }

    private ExecutionFlow<HttpResponse<?>> handleStatusException(ExecutionFlow<HttpResponse<?>> flux, HttpRequest<?> request, RouteMatch<?> routeMatch, PropagatedContext propagatedContext) {
        HttpResponse<?> response = flux.tryCompleteValue();
        if (response != null) {
            return this.handleStatusException(request, response, routeMatch, propagatedContext);
        }
        return flux.flatMap(res -> this.handleStatusException(request, (HttpResponse<?>)res, routeMatch, propagatedContext));
    }

    private ExecutionFlow<HttpResponse<?>> onErrorNoFilter(ExecutionFlow<HttpResponse<?>> flux, HttpRequest<?> request, PropagatedContext propagatedContext) {
        if (flux.tryCompleteValue() != null) {
            return flux;
        }
        Throwable throwable = flux.tryCompleteError();
        if (throwable != null) {
            return this.onErrorNoFilter(request, throwable, propagatedContext);
        }
        return flux.onErrorResume(exp -> this.onErrorNoFilter(request, (Throwable)exp, propagatedContext));
    }

    protected final ExecutionFlow<HttpResponse<?>> onError(HttpRequest<?> request, Throwable throwable) {
        try {
            return this.runWithFilters(request, (filteredRequest, propagatedContext) -> this.onErrorNoFilter((HttpRequest<?>)filteredRequest, throwable, (PropagatedContext)propagatedContext)).onErrorResume(t2 -> this.createDefaultErrorResponseFlow(request, (Throwable)t2));
        }
        catch (Throwable e) {
            return this.createDefaultErrorResponseFlow(request, e);
        }
    }

    private ExecutionFlow<HttpResponse<?>> onErrorNoFilter(HttpRequest<?> request, Throwable t2, PropagatedContext propagatedContext) {
        Throwable cause;
        RouteMatch<?> errorRoute;
        ConversionErrorException cee;
        Throwable throwable2;
        Optional<RouteInfo> previousRequestRouteInfo = request.getAttribute(HttpAttributes.ROUTE_INFO, RouteInfo.class);
        Class declaringType = previousRequestRouteInfo.map(RouteInfo::getDeclaringType).orElse(null);
        if ((t2 instanceof CompletionException || t2 instanceof ExecutionException) && t2.getCause() != null) {
            t2 = t2.getCause();
        }
        if (t2 instanceof ConversionErrorException && (throwable2 = (cee = (ConversionErrorException)t2).getCause()) instanceof JsonSyntaxException) {
            JsonSyntaxException jse = (JsonSyntaxException)throwable2;
            t2 = jse;
        }
        if ((errorRoute = this.routeExecutor.findErrorRoute(cause = t2, declaringType, request)) != null) {
            if (this.routeExecutor.serverConfiguration.isLogHandledExceptions()) {
                this.routeExecutor.logException(cause);
            }
            try {
                return ExecutionFlow.just(errorRoute).flatMap(routeMatch -> this.routeExecutor.callRoute(propagatedContext, (RouteMatch<?>)routeMatch, request).flatMap(res -> this.handleStatusException(request, (HttpResponse<?>)res, (RouteMatch<?>)routeMatch, propagatedContext))).onErrorResume(u -> this.createDefaultErrorResponseFlow(request, (Throwable)u)).map(response -> {
                    response.setAttribute(HttpAttributes.EXCEPTION, cause);
                    return response;
                }).onErrorResume(throwable -> this.createDefaultErrorResponseFlow(request, (Throwable)throwable));
            }
            catch (Throwable e) {
                return this.createDefaultErrorResponseFlow(request, e);
            }
        }
        Optional<BeanDefinition<ExceptionHandler>> optionalDefinition = this.routeExecutor.beanContext.findBeanDefinition(ExceptionHandler.class, Qualifiers.byTypeArgumentsClosest(cause.getClass(), Object.class));
        if (optionalDefinition.isPresent()) {
            BeanDefinition<ExceptionHandler> handlerDefinition = optionalDefinition.get();
            Optional optionalMethod = handlerDefinition.findPossibleMethods("handle").findFirst();
            DefaultRouteInfo routeInfo = optionalMethod.isPresent() ? new ExecutableRouteInfo(optionalMethod.get(), true) : new DefaultRouteInfo<Object>(AnnotationMetadata.EMPTY_METADATA, ReturnType.of(Object.class, new Argument[0]), List.of(), MediaType.fromType(handlerDefinition.getBeanType()).map(Collections::singletonList).orElse(Collections.emptyList()), handlerDefinition.getBeanType(), true, false, MessageBodyHandlerRegistry.EMPTY);
            Supplier<ExecutionFlow> responseSupplier = () -> {
                ExceptionHandler handler = (ExceptionHandler)this.routeExecutor.beanContext.getBean(handlerDefinition);
                try {
                    if (this.routeExecutor.serverConfiguration.isLogHandledExceptions()) {
                        this.routeExecutor.logException(cause);
                    }
                    Object result = handler.handle(request, cause);
                    return this.routeExecutor.createResponseForBody(propagatedContext, request, result, routeInfo, null);
                }
                catch (Throwable e) {
                    return this.createDefaultErrorResponseFlow(request, e);
                }
            };
            ExecutorService executor = this.routeExecutor.findExecutor(routeInfo);
            ExecutionFlow responseFlow = executor != null ? ExecutionFlow.async(executor, responseSupplier) : responseSupplier.get();
            return responseFlow.map(response -> {
                response.setAttribute(HttpAttributes.EXCEPTION, cause);
                return response;
            }).onErrorResume(throwable -> this.createDefaultErrorResponseFlow(request, (Throwable)throwable));
        }
        if (RouteExecutor.isIgnorable(cause)) {
            RouteExecutor.logIgnoredException(cause);
            return ExecutionFlow.empty();
        }
        return this.createDefaultErrorResponseFlow(request, cause);
    }

    protected final ExecutionFlow<HttpResponse<?>> runWithFilters(HttpRequest<?> request, BiFunction<HttpRequest<?>, PropagatedContext, ExecutionFlow<HttpResponse<?>>> responseProvider) {
        try {
            List<GenericHttpFilter> httpFilters = this.routeExecutor.router.findFilters(request);
            FilterRunner filterRunner = new FilterRunner(httpFilters, responseProvider){

                @Override
                protected ExecutionFlow<HttpResponse<?>> processResponse(HttpRequest<?> request, HttpResponse<?> response, PropagatedContext propagatedContext) {
                    RouteInfo routeInfo = response.getAttribute(HttpAttributes.ROUTE_INFO, RouteInfo.class).orElse(null);
                    return RequestLifecycle.this.handleStatusException(request, response, routeInfo, propagatedContext).onErrorResume(throwable -> RequestLifecycle.this.onErrorNoFilter(request, (Throwable)throwable, propagatedContext));
                }

                @Override
                protected ExecutionFlow<HttpResponse<?>> processFailure(HttpRequest<?> request, Throwable failure, PropagatedContext propagatedContext) {
                    return RequestLifecycle.this.onErrorNoFilter(request, failure, propagatedContext);
                }
            };
            return filterRunner.run(request);
        }
        catch (Throwable e) {
            return ExecutionFlow.error(e);
        }
    }

    private ExecutionFlow<HttpResponse<?>> handleStatusException(HttpRequest<?> request, HttpResponse<?> response, @Nullable RouteMatch<?> routeMatch, PropagatedContext propagatedContext) {
        if (response.code() < 400) {
            return ExecutionFlow.just(response);
        }
        RouteInfo<?> routeInfo = routeMatch == null ? null : routeMatch.getRouteInfo();
        return this.handleStatusException(request, response, routeInfo, propagatedContext);
    }

    private ExecutionFlow<HttpResponse<?>> handleStatusException(HttpRequest<?> request, HttpResponse<?> response, RouteInfo<?> routeInfo, PropagatedContext propagatedContext) {
        RouteMatch<Object> statusRoute;
        if (response.code() >= 400 && routeInfo != null && !routeInfo.isErrorRoute() && (statusRoute = this.routeExecutor.findStatusRoute(request, response.code(), routeInfo)) != null) {
            return this.executeRoute(request, propagatedContext, statusRoute);
        }
        return ExecutionFlow.just(response);
    }

    private ExecutionFlow<HttpResponse<?>> createDefaultErrorResponseFlow(HttpRequest<?> httpRequest, Throwable cause) {
        return ExecutionFlow.just(this.routeExecutor.createDefaultErrorResponse(httpRequest, cause));
    }

    final ExecutionFlow<HttpResponse<?>> onRouteMiss(HttpRequest<?> httpRequest) {
        HttpMethod httpMethod = httpRequest.getMethod();
        String requestMethodName = httpRequest.getMethodName();
        MediaType contentType = httpRequest.getContentType().orElse(null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("No matching route: {} {}", (Object)httpMethod, (Object)httpRequest.getUri());
        }
        List anyMatchingRoutes = this.routeExecutor.router.findAny(httpRequest);
        Collection<MediaType> acceptedTypes = httpRequest.accept();
        boolean hasAcceptHeader = CollectionUtils.isNotEmpty(acceptedTypes);
        HashSet<MediaType> acceptableContentTypes = contentType != null ? new HashSet<MediaType>(5) : null;
        HashSet<String> allowedMethods = new HashSet<String>(5);
        HashSet<MediaType> produceableContentTypes = hasAcceptHeader ? new HashSet<MediaType>(5) : null;
        for (UriRouteMatch anyRoute : anyMatchingRoutes) {
            String routeMethod = anyRoute.getRouteInfo().getHttpMethodName();
            if (!requestMethodName.equals(routeMethod)) {
                allowedMethods.add(routeMethod);
            }
            if (contentType != null && !anyRoute.getRouteInfo().doesConsume(contentType)) {
                acceptableContentTypes.addAll(anyRoute.getRouteInfo().getConsumes());
            }
            if (!hasAcceptHeader || anyRoute.getRouteInfo().doesProduce(acceptedTypes)) continue;
            produceableContentTypes.addAll(anyRoute.getRouteInfo().getProduces());
        }
        if (CollectionUtils.isNotEmpty(acceptableContentTypes)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Content type not allowed for URI {}, method {}, and content type {}", httpRequest.getUri(), requestMethodName, contentType);
            }
            return this.onStatusError(httpRequest, HttpResponse.status(HttpStatus.UNSUPPORTED_MEDIA_TYPE), "Content Type [" + contentType + "] not allowed. Allowed types: " + acceptableContentTypes);
        }
        if (CollectionUtils.isNotEmpty(produceableContentTypes)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Content type not allowed for URI {}, method {}, and content type {}", httpRequest.getUri(), requestMethodName, contentType);
            }
            return this.onStatusError(httpRequest, HttpResponse.status(HttpStatus.NOT_ACCEPTABLE), "Specified Accept Types " + acceptedTypes + " not supported. Supported types: " + produceableContentTypes);
        }
        if (!allowedMethods.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Method not allowed for URI {} and method {}", (Object)httpRequest.getUri(), (Object)requestMethodName);
            }
            return this.onStatusError(httpRequest, HttpResponse.notAllowedGeneric(allowedMethods), "Method [" + requestMethodName + "] not allowed for URI [" + httpRequest.getUri() + "]. Allowed methods: " + allowedMethods);
        }
        return this.onStatusError(httpRequest, HttpResponse.status(HttpStatus.NOT_FOUND), "Page Not Found");
    }

    protected final ExecutionFlow<HttpResponse<?>> onStatusError(HttpRequest<?> request, MutableHttpResponse<?> defaultResponse, String message) {
        Optional statusRoute = this.routeExecutor.router.findStatusRoute(defaultResponse.status(), request);
        if (statusRoute.isPresent()) {
            return this.runWithFilters(request, (filteredRequest, propagatedContext) -> this.executeRoute((HttpRequest<?>)filteredRequest, (PropagatedContext)propagatedContext, (RouteMatch)statusRoute.get()));
        }
        if (request.getMethod() != HttpMethod.HEAD && (defaultResponse = this.routeExecutor.errorResponseProcessor.processResponse(ErrorContext.builder(request).errorMessage(message).build(), (MutableHttpResponse<?>)defaultResponse)).getContentType().isEmpty()) {
            defaultResponse = defaultResponse.contentType(MediaType.APPLICATION_JSON_TYPE);
        }
        MutableHttpResponse<?> finalDefaultResponse = defaultResponse;
        return this.runWithFilters(request, (filteredRequest, propagatedContext) -> ExecutionFlow.just(finalDefaultResponse));
    }

    @Nullable
    protected FileCustomizableResponseType findFile(HttpRequest<?> request) {
        return this.findFile();
    }

    protected ExecutionFlow<RouteMatch<?>> fulfillArguments(RouteMatch<?> routeMatch, HttpRequest<?> request) {
        try {
            this.routeExecutor.requestArgumentSatisfier.fulfillArgumentRequirementsBeforeFilters(routeMatch, request);
            return ExecutionFlow.just(routeMatch);
        }
        catch (Throwable e) {
            return ExecutionFlow.error(e);
        }
    }
}

