/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.util.HttpHeadersUtil;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValidationUtil;
import io.netty.handler.codec.http.HttpHeaders;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;

@Internal
public class NettyHttpHeaders
implements MutableHttpHeaders {
    private final HttpHeaders nettyHeaders;
    private ConversionService conversionService;
    @Nullable
    private OptionalLong contentLength;
    @Nullable
    private Optional<MediaType> contentType;
    @Nullable
    private Optional<String> origin;
    @Nullable
    private List<MediaType> accept;
    @Nullable
    private Optional<Charset> acceptCharset;
    @Nullable
    private Optional<Locale> acceptLanguage;

    public NettyHttpHeaders(HttpHeaders nettyHeaders, ConversionService conversionService) {
        this.nettyHeaders = nettyHeaders;
        this.conversionService = conversionService;
    }

    public NettyHttpHeaders() {
        this.nettyHeaders = new DefaultHttpHeaders(false);
        this.conversionService = ConversionService.SHARED;
    }

    public HttpHeaders getNettyHeaders() {
        return this.nettyHeaders;
    }

    @Override
    public final boolean contains(String name) {
        return this.nettyHeaders.contains(name);
    }

    @Override
    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        List<String> values = this.nettyHeaders.getAll(name);
        if (!values.isEmpty()) {
            if (values.size() == 1 || !this.isCollectionOrArray(conversionContext.getArgument().getType())) {
                return this.conversionService.convert((Object)values.get(0), conversionContext);
            }
            return this.conversionService.convert(values, conversionContext);
        }
        return Optional.empty();
    }

    private boolean isCollectionOrArray(Class<?> clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz);
    }

    @Override
    public List<String> getAll(CharSequence name) {
        return this.nettyHeaders.getAll(name);
    }

    @Override
    public Set<String> names() {
        return this.nettyHeaders.names();
    }

    @Override
    public Collection<List<String>> values() {
        Set<String> names = this.names();
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        for (String name : names) {
            values.add(this.getAll(name));
        }
        return Collections.unmodifiableList(values);
    }

    @Override
    public String get(CharSequence name) {
        return this.nettyHeaders.get(name);
    }

    @Override
    public Optional<String> findFirst(CharSequence name) {
        return Optional.ofNullable(this.get(name));
    }

    @Override
    public MutableHttpHeaders add(CharSequence header, CharSequence value) {
        NettyHttpHeaders.validateHeader(header, value);
        this.nettyHeaders.add(header, (Object)value);
        this.onModify();
        return this;
    }

    @Override
    public MutableHeaders set(CharSequence header, CharSequence value) {
        NettyHttpHeaders.validateHeader(header, value);
        this.nettyHeaders.set(header, (Object)value);
        this.onModify();
        return this;
    }

    private void onModify() {
        this.contentType = null;
        this.contentLength = null;
        this.accept = null;
        this.acceptCharset = null;
        this.acceptLanguage = null;
        this.origin = null;
    }

    public void setUnsafe(CharSequence header, CharSequence value) {
        this.nettyHeaders.set(header, (Object)value);
    }

    public static void validateHeader(CharSequence name, CharSequence value) {
        if (name == null || name.isEmpty() || HttpHeaderValidationUtil.validateToken(name) != -1) {
            throw new IllegalArgumentException("Invalid header name");
        }
        if (HttpHeaderValidationUtil.validateValidHeaderValue(value) != -1) {
            throw new IllegalArgumentException("Invalid header value");
        }
    }

    @Override
    public MutableHttpHeaders remove(CharSequence header) {
        this.nettyHeaders.remove(header);
        this.onModify();
        return this;
    }

    @Override
    public MutableHttpHeaders date(LocalDateTime date) {
        if (date != null) {
            this.setUnsafe((CharSequence)HttpHeaderNames.DATE, ZonedDateTime.of(date, ZoneId.systemDefault()));
        }
        return this;
    }

    @Override
    public MutableHttpHeaders expires(LocalDateTime date) {
        if (date != null) {
            this.setUnsafe((CharSequence)HttpHeaderNames.EXPIRES, ZonedDateTime.of(date, ZoneId.systemDefault()));
        }
        return this;
    }

    @Override
    public MutableHttpHeaders lastModified(LocalDateTime date) {
        if (date != null) {
            this.setUnsafe((CharSequence)HttpHeaderNames.LAST_MODIFIED, ZonedDateTime.of(date, ZoneId.systemDefault()));
        }
        return this;
    }

    @Override
    public MutableHttpHeaders ifModifiedSince(LocalDateTime date) {
        if (date != null) {
            this.setUnsafe((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE, ZonedDateTime.of(date, ZoneId.systemDefault()));
        }
        return this;
    }

    @Override
    public MutableHttpHeaders date(long timeInMillis) {
        this.setUnsafe((CharSequence)HttpHeaderNames.DATE, ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeInMillis), ZoneId.systemDefault()));
        return this;
    }

    @Override
    public MutableHttpHeaders expires(long timeInMillis) {
        this.setUnsafe((CharSequence)HttpHeaderNames.EXPIRES, ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeInMillis), ZoneId.systemDefault()));
        return this;
    }

    @Override
    public MutableHttpHeaders lastModified(long timeInMillis) {
        this.setUnsafe((CharSequence)HttpHeaderNames.LAST_MODIFIED, ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeInMillis), ZoneId.systemDefault()));
        return this;
    }

    @Override
    public MutableHttpHeaders ifModifiedSince(long timeInMillis) {
        this.setUnsafe((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE, ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeInMillis), ZoneId.systemDefault()));
        return this;
    }

    private void setUnsafe(CharSequence header, ZonedDateTime value) {
        this.setUnsafe(header, value.withZoneSameInstant(GMT).format(DateTimeFormatter.RFC_1123_DATE_TIME));
    }

    @Override
    public MutableHttpHeaders auth(String userInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("Basic");
        sb.append(" ");
        sb.append(Base64.getEncoder().encodeToString(userInfo.getBytes(StandardCharsets.ISO_8859_1)));
        String token = sb.toString();
        this.add((CharSequence)HttpHeaderNames.AUTHORIZATION, token);
        return this;
    }

    @Override
    public MutableHttpHeaders allowGeneric(Collection<? extends CharSequence> methods) {
        String value = methods.stream().distinct().collect(Collectors.joining(","));
        return this.add((CharSequence)HttpHeaderNames.ALLOW, value);
    }

    @Override
    public MutableHttpHeaders location(URI uri) {
        this.setUnsafe((CharSequence)HttpHeaderNames.LOCATION, uri.toString());
        return this;
    }

    @Override
    public MutableHttpHeaders contentType(MediaType mediaType) {
        if (mediaType == null) {
            this.nettyHeaders.remove(HttpHeaderNames.CONTENT_TYPE);
        } else {
            mediaType.validate(() -> NettyHttpHeaders.validateHeader(HttpHeaderNames.CONTENT_TYPE, mediaType));
            this.nettyHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mediaType);
        }
        this.contentType = Optional.ofNullable(mediaType);
        return this;
    }

    @Override
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    @Override
    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Optional<MediaType> contentType() {
        Optional<MediaType> cachedContentType = this.contentType;
        if (cachedContentType == null) {
            this.contentType = cachedContentType = this.resolveContentType();
        }
        return cachedContentType;
    }

    private Optional<MediaType> resolveContentType() {
        String str = this.get(HttpHeaderNames.CONTENT_TYPE);
        if (str != null) {
            try {
                return Optional.of(MediaType.of(str));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public OptionalLong contentLength() {
        OptionalLong cachedContentLength = this.contentLength;
        if (cachedContentLength == null) {
            this.contentLength = cachedContentLength = this.resolveContentLength();
        }
        return cachedContentLength;
    }

    private OptionalLong resolveContentLength() {
        String str = this.get(HttpHeaderNames.CONTENT_LENGTH);
        if (str != null) {
            try {
                return OptionalLong.of(Long.parseLong(str));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return OptionalLong.empty();
    }

    @Override
    public List<MediaType> accept() {
        List<MediaType> cachedAccept = this.accept;
        if (cachedAccept == null) {
            this.accept = cachedAccept = this.resolveAccept();
        }
        return cachedAccept;
    }

    private List<MediaType> resolveAccept() {
        return MediaType.orderedOf(this.getAll(HttpHeaderNames.ACCEPT));
    }

    @Override
    public Optional<Charset> findAcceptCharset() {
        Optional<Charset> cachedAcceptCharset = this.acceptCharset;
        if (cachedAcceptCharset == null) {
            this.acceptCharset = cachedAcceptCharset = this.resolveAcceptCharset();
        }
        return cachedAcceptCharset;
    }

    private Optional<Charset> resolveAcceptCharset() {
        String text = this.get(HttpHeaderNames.ACCEPT_CHARSET);
        if (text == null) {
            return Optional.empty();
        }
        if ((text = HttpHeadersUtil.splitAcceptHeader(text)) != null) {
            try {
                return Optional.of(Charset.forName(text));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.of(StandardCharsets.UTF_8);
    }

    @Override
    public Optional<Locale> findAcceptLanguage() {
        Optional<Locale> cachedAcceptLanguage = this.acceptLanguage;
        if (cachedAcceptLanguage == null) {
            this.acceptLanguage = cachedAcceptLanguage = this.resolveAcceptLanguage();
        }
        return cachedAcceptLanguage;
    }

    private Optional<Locale> resolveAcceptLanguage() {
        String text = this.get(HttpHeaderNames.ACCEPT_LANGUAGE);
        if (text == null) {
            return Optional.empty();
        }
        String part = HttpHeadersUtil.splitAcceptHeader(text);
        return Optional.ofNullable(part == null ? Locale.getDefault() : Locale.forLanguageTag(part));
    }

    @Override
    public Optional<String> getOrigin() {
        Optional<String> cachedOrigin = this.origin;
        if (cachedOrigin == null) {
            this.origin = cachedOrigin = this.resolveOrigin();
        }
        return cachedOrigin;
    }

    private Optional<String> resolveOrigin() {
        Optional<String> cachedOrigin = this.origin;
        if (cachedOrigin == null) {
            cachedOrigin = this.findFirst(HttpHeaderNames.ORIGIN);
        }
        return cachedOrigin;
    }
}

