/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.model;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.TypeDef;
import io.micronaut.sourcegen.model.VariableDef;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface StatementDef {
    default public StatementDef after(StatementDef statement) {
        return StatementDef.multi(this, statement);
    }

    default public List<StatementDef> flatten() {
        return List.of(this);
    }

    public Stream<? extends ExpressionDef> nestedExpressionsStream();

    default public Try doTry() {
        return new Try(this);
    }

    public static Try doTry(StatementDef statement) {
        return new Try(statement);
    }

    public static StatementDef multi(@NonNull List<StatementDef> statements) {
        return new Multi(statements);
    }

    public static StatementDef multi(StatementDef ... statements) {
        return StatementDef.multi(List.of(statements));
    }

    public record Try(StatementDef statement, List<Catch> catches, @Nullable StatementDef finallyStatement) implements StatementDef
    {
        public Try(StatementDef statement) {
            this(statement, List.of(), null);
        }

        @Override
        public Stream<? extends ExpressionDef> nestedExpressionsStream() {
            return Stream.concat(this.statement.nestedExpressionsStream(), Stream.concat(this.catches.stream().flatMap(c -> c.statement.nestedExpressionsStream()), this.finallyStatement == null ? Stream.empty() : this.finallyStatement.nestedExpressionsStream()));
        }

        public Try doCatch(Class<?> exception, Function<VariableDef.ExceptionVar, StatementDef> catchBlock) {
            return this.doCatch(ClassTypeDef.of(exception), catchBlock);
        }

        public Try doCatch(ClassTypeDef exception, Function<VariableDef.ExceptionVar, StatementDef> catchBlock) {
            return new Try(this.statement, CollectionUtils.concat(this.catches, (Object)new Catch(exception, catchBlock.apply(new VariableDef.ExceptionVar(exception)))), this.finallyStatement);
        }

        public Try doFinally(StatementDef finallyStatement) {
            if (this.finallyStatement != null) {
                throw new IllegalStateException("Finally statement already exists!");
            }
            return new Try(this.statement, this.catches, finallyStatement);
        }

        public record Catch(ClassTypeDef exception, StatementDef statement) {
        }
    }

    public record Multi(@NonNull List<StatementDef> statements) implements StatementDef
    {
        @NonNull
        private final List<StatementDef> statements;

        @Override
        public Stream<? extends ExpressionDef> nestedExpressionsStream() {
            return this.statements.stream().flatMap(StatementDef::nestedExpressionsStream);
        }

        public List<StatementDef> statements() {
            return this.flatten();
        }

        @Override
        public List<StatementDef> flatten() {
            ArrayList<StatementDef> result = new ArrayList<StatementDef>(this.statements.size());
            for (StatementDef statement : this.statements) {
                result.addAll(statement.flatten());
            }
            return result;
        }
    }

    public record Synchronized(ExpressionDef monitor, StatementDef statement) implements StatementDef
    {
        @Override
        public Stream<? extends ExpressionDef> nestedExpressionsStream() {
            return Stream.concat(Stream.of(this.monitor), this.statement.nestedExpressionsStream());
        }
    }

    public record While(ExpressionDef expression, StatementDef statement) implements StatementDef
    {
        @Override
        public Stream<? extends ExpressionDef> nestedExpressionsStream() {
            return Stream.concat(Stream.of(this.expression), this.statement.nestedExpressionsStream());
        }
    }

    public record Switch(ExpressionDef expression, TypeDef type, Map<ExpressionDef.Constant, StatementDef> cases, @Nullable StatementDef defaultCase) implements StatementDef
    {
        @Override
        public Stream<? extends ExpressionDef> nestedExpressionsStream() {
            return Stream.concat(Stream.of(this.expression), Stream.concat(this.cases.values().stream().flatMap(StatementDef::nestedExpressionsStream), this.defaultCase == null ? Stream.empty() : this.defaultCase.nestedExpressionsStream()));
        }
    }

    public record IfElse(ExpressionDef condition, StatementDef statement, StatementDef elseStatement) implements StatementDef
    {
        @Override
        public Stream<? extends ExpressionDef> nestedExpressionsStream() {
            return Stream.concat(Stream.of(this.condition), Stream.concat(this.statement.nestedExpressionsStream(), this.elseStatement.nestedExpressionsStream()));
        }
    }

    public record If(ExpressionDef condition, StatementDef statement) implements StatementDef
    {
        @Override
        public Stream<? extends ExpressionDef> nestedExpressionsStream() {
            return Stream.concat(Stream.of(this.condition), this.statement.nestedExpressionsStream());
        }
    }

    public record DefineAndAssign(VariableDef.Local variable, ExpressionDef expression) implements StatementDef
    {
        @Override
        public Stream<? extends ExpressionDef> nestedExpressionsStream() {
            return Stream.of(this.variable, this.expression);
        }
    }

    public record PutStaticField(VariableDef.StaticField field, ExpressionDef expression) implements StatementDef
    {
        @Override
        public Stream<? extends ExpressionDef> nestedExpressionsStream() {
            return Stream.of(this.field, this.expression);
        }
    }

    public record PutField(VariableDef.Field field, ExpressionDef expression) implements StatementDef
    {
        @Override
        public Stream<? extends ExpressionDef> nestedExpressionsStream() {
            return Stream.of(this.field, this.expression);
        }
    }

    public record Assign(VariableDef.Local variable, ExpressionDef expression) implements StatementDef
    {
        @Override
        public Stream<? extends ExpressionDef> nestedExpressionsStream() {
            return Stream.of(this.variable, this.expression);
        }
    }

    public record Return(@Nullable ExpressionDef expression) implements StatementDef
    {
        public void validate(MethodDef method) {
            if ((this.expression == null || this.expression.type().equals(TypeDef.VOID)) && !method.getReturnType().equals(TypeDef.VOID)) {
                throw new IllegalStateException("The return expression returns VOID but method: " + method.getName() + " doesn't return VOID (" + method.getReturnType() + ")!");
            }
            if (this.expression != null && !this.expression.type().equals(TypeDef.VOID) && method.getReturnType().equals(TypeDef.VOID)) {
                throw new IllegalStateException("The return expression (" + this.expression.type() + ") doesn't returns VOID but method: " + method.getName() + " returns VOID!");
            }
        }

        @Override
        public Stream<? extends ExpressionDef> nestedExpressionsStream() {
            return this.expression == null ? Stream.empty() : Stream.of(this.expression);
        }
    }

    public record Throw(ExpressionDef expression) implements StatementDef
    {
        @Override
        public Stream<? extends ExpressionDef> nestedExpressionsStream() {
            return Stream.of(this.expression);
        }
    }
}

