/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.reader;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.token.reader.TokenReader;
import io.micronaut.security.token.reader.TokenResolver;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(classes={HttpRequest.class})
@Singleton
public class DefaultTokenResolver
implements TokenResolver<HttpRequest<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTokenResolver.class);
    private final List<TokenReader<HttpRequest<?>>> tokenReaders;

    @Deprecated(forRemoval=true, since="4.4.0")
    public DefaultTokenResolver(Collection<TokenReader<HttpRequest<?>>> tokenReaders) {
        this(new ArrayList(tokenReaders));
    }

    @Inject
    public DefaultTokenResolver(List<TokenReader<HttpRequest<?>>> tokenReaders) {
        this.tokenReaders = tokenReaders;
    }

    @Override
    @NonNull
    public List<String> resolveTokens(@NonNull HttpRequest<?> request) {
        List<String> tokens = this.tokenReaders.stream().map(reader -> reader.findToken(request)).filter(Optional::isPresent).map(Optional::get).peek(token -> {
            if (LOG.isDebugEnabled()) {
                String method = request.getMethod().toString();
                String path = request.getPath();
                LOG.debug("Token {} found in request {} {}", new Object[]{token, method, path});
            }
        }).toList();
        if (LOG.isDebugEnabled() && CollectionUtils.isEmpty(tokens)) {
            String method = request.getMethod().toString();
            String path = request.getPath();
            LOG.debug("Request {}, {}, no token found.", (Object)method, (Object)path);
        }
        return tokens;
    }

    @Override
    public Optional<String> resolveToken(HttpRequest<?> request) {
        return this.resolveTokens(request).stream().findFirst();
    }
}

