/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import com.fasterxml.jackson.annotation.JsonValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Serdeable
public class ServerAuthentication
implements Authentication {
    private static final String JSON_KEY_NAME = "name";
    private static final String JSON_KEY_ATTRIBUTES = "attributes";
    @NonNull
    @NotBlank
    private final String name;
    @NonNull
    @NotNull
    private final Collection<String> roles;
    @NonNull
    @NotNull
    private final Map<String, Object> attributes;

    public ServerAuthentication(@NonNull String name, @Nullable Collection<String> roles, @Nullable Map<String, Object> attributes) {
        this.name = name;
        this.roles = roles == null || roles.isEmpty() ? new ArrayList() : roles;
        this.attributes = attributes == null ? Collections.emptyMap() : attributes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    @NonNull
    public Collection<String> getRoles() {
        return Collections.unmodifiableCollection(this.roles);
    }

    @JsonValue
    public Map<String, Object> toJson() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put(JSON_KEY_NAME, this.getName());
        HashMap<String, Object> jsonAttributes = new HashMap<String, Object>(this.getAttributes());
        jsonAttributes.putIfAbsent("roles", this.getRoles());
        json.put(JSON_KEY_ATTRIBUTES, jsonAttributes);
        return json;
    }
}

