/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.cookie;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.security.authentication.CookieBasedAuthenticationModeCondition;
import io.micronaut.security.token.cookie.AccessTokenCookieConfiguration;
import io.micronaut.security.token.reader.TokenReader;
import jakarta.inject.Singleton;
import java.util.Optional;

@Requirements(value={@Requires(classes={HttpRequest.class}), @Requires(condition=CookieBasedAuthenticationModeCondition.class), @Requires(property="micronaut.security.token.cookie.enabled", notEquals="false", defaultValue="true")})
@Singleton
public class TokenCookieTokenReader
implements TokenReader<HttpRequest<?>> {
    public static final Integer ORDER = 0;
    protected final AccessTokenCookieConfiguration accessTokenCookieConfiguration;

    public TokenCookieTokenReader(AccessTokenCookieConfiguration accessTokenCookieConfiguration) {
        this.accessTokenCookieConfiguration = accessTokenCookieConfiguration;
    }

    @Override
    public Optional<String> findToken(HttpRequest<?> request) {
        Optional optionalCookie = request.getCookies().findCookie((CharSequence)this.accessTokenCookieConfiguration.getCookieName());
        return optionalCookie.map(Cookie::getValue);
    }

    public int getOrder() {
        return ORDER;
    }
}

