/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.generator;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.token.claims.ClaimsGenerator;
import io.micronaut.security.token.event.AccessTokenGeneratedEvent;
import io.micronaut.security.token.event.RefreshTokenGeneratedEvent;
import io.micronaut.security.token.generator.AccessRefreshTokenGenerator;
import io.micronaut.security.token.generator.AccessTokenConfiguration;
import io.micronaut.security.token.generator.RefreshTokenGenerator;
import io.micronaut.security.token.generator.TokenGenerator;
import io.micronaut.security.token.refresh.RefreshTokenPersistence;
import io.micronaut.security.token.render.AccessRefreshToken;
import io.micronaut.security.token.render.TokenRenderer;
import io.micronaut.security.token.validator.RefreshTokenValidator;
import io.micronaut.security.utils.LoggingUtils;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(beans={AccessTokenConfiguration.class, TokenRenderer.class, TokenGenerator.class, ClaimsGenerator.class})
@Singleton
public class DefaultAccessRefreshTokenGenerator
implements AccessRefreshTokenGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAccessRefreshTokenGenerator.class);
    protected final BeanContext beanContext;
    protected final RefreshTokenGenerator refreshTokenGenerator;
    protected final ClaimsGenerator claimsGenerator;
    protected final AccessTokenConfiguration accessTokenConfiguration;
    protected final TokenRenderer tokenRenderer;
    protected final TokenGenerator tokenGenerator;
    protected final ApplicationEventPublisher<RefreshTokenGeneratedEvent> refreshTokenGeneratedEventPublisher;
    protected final ApplicationEventPublisher<AccessTokenGeneratedEvent> accessTokenGeneratedEventPublisher;

    public DefaultAccessRefreshTokenGenerator(AccessTokenConfiguration accessTokenConfiguration, TokenRenderer tokenRenderer, TokenGenerator tokenGenerator, BeanContext beanContext, @Nullable RefreshTokenGenerator refreshTokenGenerator, ClaimsGenerator claimsGenerator, ApplicationEventPublisher<RefreshTokenGeneratedEvent> refreshTokenGeneratedEventPublisher, ApplicationEventPublisher<AccessTokenGeneratedEvent> accessTokenGeneratedEventPublisher) {
        this.accessTokenConfiguration = accessTokenConfiguration;
        this.tokenRenderer = tokenRenderer;
        this.tokenGenerator = tokenGenerator;
        this.beanContext = beanContext;
        this.refreshTokenGenerator = refreshTokenGenerator;
        this.claimsGenerator = claimsGenerator;
        this.refreshTokenGeneratedEventPublisher = refreshTokenGeneratedEventPublisher;
        this.accessTokenGeneratedEventPublisher = accessTokenGeneratedEventPublisher;
    }

    @Override
    @NonNull
    public Optional<AccessRefreshToken> generate(@NonNull Authentication authentication) {
        return this.generate((String)this.generateRefreshToken(authentication).orElse(null), authentication);
    }

    @Override
    @NonNull
    public Optional<String> generateRefreshToken(@NonNull Authentication authentication) {
        Optional<String> refreshToken = Optional.empty();
        String msg = "Skipped refresh token generation because no {} implementation is present";
        if (this.beanContext.containsBean(RefreshTokenValidator.class)) {
            if (this.beanContext.containsBean(RefreshTokenPersistence.class)) {
                if (this.refreshTokenGenerator != null) {
                    String key = this.refreshTokenGenerator.createKey(authentication);
                    refreshToken = this.refreshTokenGenerator.generate(authentication, key);
                    refreshToken.ifPresent(t -> this.refreshTokenGeneratedEventPublisher.publishEvent((Object)new RefreshTokenGeneratedEvent(authentication, key)));
                } else {
                    LoggingUtils.debug(LOG, msg, RefreshTokenGenerator.class.getName());
                }
            } else {
                LoggingUtils.debug(LOG, msg, RefreshTokenPersistence.class.getName());
            }
        } else {
            LoggingUtils.debug(LOG, msg, RefreshTokenValidator.class.getName());
        }
        return refreshToken;
    }

    @Override
    @NonNull
    public Optional<AccessRefreshToken> generate(@Nullable String refreshToken, @NonNull Map<String, ?> oldClaims) {
        Map<String, Object> claims = this.claimsGenerator.generateClaimsSet(oldClaims, this.accessTokenExpiration(oldClaims));
        Optional<String> optionalAccessToken = this.tokenGenerator.generateToken(claims);
        if (!optionalAccessToken.isPresent()) {
            LoggingUtils.debug(LOG, "tokenGenerator failed to generate access token claims: {}", claims.entrySet().stream().map(entry -> (String)entry.getKey() + "=>" + entry.getValue().toString()).collect(Collectors.joining(", ")));
            return Optional.empty();
        }
        String accessToken = optionalAccessToken.get();
        this.accessTokenGeneratedEventPublisher.publishEvent((Object)new AccessTokenGeneratedEvent(accessToken));
        return Optional.of(this.tokenRenderer.render(this.accessTokenExpiration(oldClaims), accessToken, refreshToken));
    }

    @Override
    @NonNull
    public Optional<AccessRefreshToken> generate(@Nullable String refreshToken, @NonNull Authentication authentication) {
        Optional<String> optionalAccessToken = this.tokenGenerator.generateToken(authentication, this.accessTokenExpiration(authentication));
        if (!optionalAccessToken.isPresent()) {
            LoggingUtils.debug(LOG, "Failed to generate access token for user {}", authentication.getName());
            return Optional.empty();
        }
        String accessToken = optionalAccessToken.get();
        this.accessTokenGeneratedEventPublisher.publishEvent((Object)new AccessTokenGeneratedEvent(accessToken));
        return Optional.of(this.tokenRenderer.render(authentication, this.accessTokenExpiration(authentication), accessToken, refreshToken));
    }

    @NonNull
    public Integer accessTokenExpiration(@NonNull Authentication authentication) {
        return this.accessTokenConfiguration.getExpiration();
    }

    @NonNull
    public Integer accessTokenExpiration(@NonNull Map<String, ?> oldClaims) {
        return this.accessTokenConfiguration.getExpiration();
    }
}

