/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.security.authentication.BasicAuthAuthenticationFetcher;
import io.micronaut.security.authentication.WwwAuthenticateChallenge;
import io.micronaut.security.authentication.WwwAuthenticateChallengeProvider;
import jakarta.inject.Singleton;

@Requirements(value={@Requires(classes={HttpRequest.class}), @Requires(beans={ApplicationConfiguration.class, BasicAuthAuthenticationFetcher.class}), @Requires(property="micronaut.security.basic-auth.enabled", notEquals="false"), @Requires(property="micronaut.security.basic-auth.www-authenticate", notEquals="false", defaultValue="true")})
@Internal
@Singleton
class BasicAuthWwwAuthenticateChallengeProvider
implements WwwAuthenticateChallengeProvider<HttpRequest<?>> {
    private static final String PARAM_REALM = "realm";
    private static final String PARAM_NAME_CHARSET = "charset";
    private static final String UTF_8 = "UTF-8";
    private final ApplicationConfiguration applicationConfiguration;

    BasicAuthWwwAuthenticateChallengeProvider(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    @Override
    @NonNull
    public String getWwwAuthenticateChallenge(@Nullable HttpRequest<?> request) {
        WwwAuthenticateChallenge.Builder builder = WwwAuthenticateChallenge.builder().authScheme("Basic").param(PARAM_NAME_CHARSET, UTF_8);
        this.applicationConfiguration.getName().ifPresent(name -> builder.param(PARAM_REALM, name));
        return builder.build().toString();
    }
}

