/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.authentication.AuthenticationRequest;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.authentication.provider.AuthenticationProvider;
import io.micronaut.security.authentication.provider.ReactiveAuthenticationProvider;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

@Internal
final class AuthenticationProviderAdapter<T, I, S>
implements ReactiveAuthenticationProvider<T, I, S> {
    @NonNull
    private final AuthenticationProvider<T, I, S> authenticationProvider;
    @Nullable
    private final Scheduler scheduler;

    public AuthenticationProviderAdapter(@NonNull AuthenticationProvider<T, I, S> authenticationProvider, @NonNull Scheduler scheduler) {
        this.authenticationProvider = authenticationProvider;
        this.scheduler = scheduler;
    }

    public AuthenticationProviderAdapter(@NonNull AuthenticationProvider<T, I, S> authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
        this.scheduler = null;
    }

    @Override
    public Publisher<AuthenticationResponse> authenticate(T requestContext, AuthenticationRequest<I, S> authenticationRequest) {
        Mono authenticationResponseMono = Mono.fromCallable(() -> this.authenticationProvider.authenticate(requestContext, authenticationRequest));
        return this.scheduler != null ? authenticationResponseMono.subscribeOn(this.scheduler) : authenticationResponseMono;
    }
}

