/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.config;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.http.HttpMethod;
import io.micronaut.security.config.InterceptUrlMapPattern;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Requires(classes={HttpMethod.class})
@Singleton
public class InterceptUrlMapConverter
implements TypeConverter<Map<String, Object>, InterceptUrlMapPattern> {
    private static final String PATTERN = "pattern";
    private static final String ACCESS = "access";
    private static final String HTTP_METHOD = "http-method";
    private final ConversionService conversionService;

    InterceptUrlMapConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Optional<InterceptUrlMapPattern> convert(Map<String, Object> m, Class<InterceptUrlMapPattern> targetType, ConversionContext context) {
        if (m == null) {
            return Optional.empty();
        }
        Optional optionalPattern = this.conversionService.convert((m = this.transform(m)).get(PATTERN), String.class);
        if (optionalPattern.isPresent()) {
            Optional optionalAccessList = this.conversionService.convert(m.get(ACCESS), List.class);
            if (optionalAccessList.isPresent()) {
                Optional httpMethod;
                ArrayList accessList = new ArrayList();
                for (Object obj : (List)optionalAccessList.get()) {
                    this.conversionService.convert(obj, String.class).ifPresent(accessList::add);
                }
                if (m.containsKey(HTTP_METHOD)) {
                    httpMethod = this.conversionService.convert(m.get(HTTP_METHOD), HttpMethod.class);
                    if (!httpMethod.isPresent()) {
                        throw new ConfigurationException(String.format("interceptUrlMap configuration record %s rejected due to invalid %s key.", m.toString(), HTTP_METHOD));
                    }
                } else {
                    httpMethod = Optional.empty();
                }
                return optionalPattern.map(pattern -> new InterceptUrlMapPattern((String)pattern, accessList, httpMethod.orElse(null)));
            }
            throw new ConfigurationException(String.format("interceptUrlMap configuration record %s rejected due to missing or empty %s key.", m.toString(), ACCESS));
        }
        throw new ConfigurationException(String.format("interceptUrlMap configuration record %s rejected due to missing %s key.", m.toString(), PATTERN));
    }

    private Map<String, Object> transform(Map<String, Object> map) {
        HashMap<String, Object> transformed = new HashMap<String, Object>();
        StringConvention convention = StringConvention.HYPHENATED;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            transformed.put(convention.format(entry.getKey()), entry.getValue());
        }
        return transformed;
    }
}

