/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.token.Claims;
import io.micronaut.security.token.MapClaims;
import io.micronaut.security.token.RolesFinder;
import io.micronaut.security.token.TokenAuthenticationFactory;
import io.micronaut.security.token.config.TokenConfiguration;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTokenAuthenticationFactory<T>
implements TokenAuthenticationFactory<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTokenAuthenticationFactory.class);
    private final TokenConfiguration tokenConfiguration;
    private final RolesFinder rolesFinder;

    public AbstractTokenAuthenticationFactory(TokenConfiguration tokenConfiguration, RolesFinder rolesFinder) {
        this.tokenConfiguration = tokenConfiguration;
        this.rolesFinder = rolesFinder;
    }

    @NonNull
    protected Optional<String> usernameForClaims(@NonNull Claims claims) {
        Object username = claims.get(this.tokenConfiguration.getNameKey());
        if (username != null) {
            return Optional.of(username.toString());
        }
        Object sub = claims.get("sub");
        if (sub == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(sub.toString());
    }

    @Override
    protected Optional<Authentication> createAuthentication(@NonNull Map<String, Object> attributes) {
        return this.usernameForClaims(new MapClaims(attributes)).map(username -> Authentication.build(username, this.rolesFinder.resolveRoles(attributes), attributes));
    }
}

