/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.endpoints;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.CookieValue;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.endpoints.OauthControllerConfiguration;
import io.micronaut.security.endpoints.OauthControllerConfigurationProperties;
import io.micronaut.security.endpoints.TokenRefreshRequest;
import io.micronaut.security.errors.IssuingAnAccessTokenErrorCode;
import io.micronaut.security.errors.OauthErrorResponseException;
import io.micronaut.security.handlers.LoginHandler;
import io.micronaut.security.token.refresh.RefreshTokenPersistence;
import io.micronaut.security.token.validator.RefreshTokenValidator;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Requirements(value={@Requires(property="micronaut.security.endpoints.oauth.enabled", notEquals="false"), @Requires(classes={Controller.class}), @Requires(beans={RefreshTokenPersistence.class}), @Requires(beans={RefreshTokenValidator.class})})
@Controller(value="${micronaut.security.endpoints.oauth.path:/oauth/access_token}")
@Secured(value={"isAnonymous()"})
public class OauthController {
    private final RefreshTokenPersistence refreshTokenPersistence;
    private final RefreshTokenValidator refreshTokenValidator;
    private final OauthControllerConfiguration oauthControllerConfiguration;
    private final LoginHandler<HttpRequest<?>, MutableHttpResponse<?>> loginHandler;

    @Inject
    public OauthController(RefreshTokenPersistence refreshTokenPersistence, RefreshTokenValidator refreshTokenValidator, OauthControllerConfiguration oauthControllerConfiguration, LoginHandler<HttpRequest<?>, MutableHttpResponse<?>> loginHandler) {
        this.refreshTokenPersistence = refreshTokenPersistence;
        this.refreshTokenValidator = refreshTokenValidator;
        this.oauthControllerConfiguration = oauthControllerConfiguration;
        this.loginHandler = loginHandler;
    }

    @Deprecated(forRemoval=true, since="4.11.0")
    public OauthController(RefreshTokenPersistence refreshTokenPersistence, RefreshTokenValidator refreshTokenValidator, OauthControllerConfigurationProperties oauthControllerConfigurationProperties, LoginHandler<HttpRequest<?>, MutableHttpResponse<?>> loginHandler) {
        this.refreshTokenPersistence = refreshTokenPersistence;
        this.refreshTokenValidator = refreshTokenValidator;
        this.oauthControllerConfiguration = oauthControllerConfigurationProperties;
        this.loginHandler = loginHandler;
    }

    @Consumes(value={"application/x-www-form-urlencoded", "application/json"})
    @Post
    @SingleResult
    public Publisher<MutableHttpResponse<?>> index(HttpRequest<?> request, @Nullable @Body Map<String, String> body, @Nullable @CookieValue(value="JWT_REFRESH_TOKEN") String cookieRefreshToken) {
        Optional contentTypeOptional = request.getContentType();
        if (!contentTypeOptional.isPresent() || !this.oauthControllerConfiguration.getPostContentTypes().contains(((MediaType)contentTypeOptional.get()).toString())) {
            return Publishers.just((Object)HttpResponse.notFound());
        }
        TokenRefreshRequest tokenRefreshRequest = body == null ? null : new TokenRefreshRequest(body.get("grant_type"), body.get("refresh_token"));
        String refreshToken = this.resolveRefreshToken(tokenRefreshRequest, cookieRefreshToken);
        return this.createResponse(request, refreshToken);
    }

    @Get
    @SingleResult
    public Publisher<MutableHttpResponse<?>> index(HttpRequest<?> request, @Nullable @CookieValue(value="JWT_REFRESH_TOKEN") String cookieRefreshToken) {
        if (!this.oauthControllerConfiguration.isGetAllowed()) {
            return Mono.just((Object)HttpResponse.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED));
        }
        String refreshToken = this.resolveRefreshToken(null, cookieRefreshToken);
        return this.createResponse(request, refreshToken);
    }

    @SingleResult
    private Publisher<MutableHttpResponse<?>> createResponse(HttpRequest<?> request, String refreshToken) {
        Optional<String> validRefreshToken = this.refreshTokenValidator.validate(refreshToken);
        if (!validRefreshToken.isPresent()) {
            throw new OauthErrorResponseException(IssuingAnAccessTokenErrorCode.INVALID_GRANT, "Refresh token is invalid", null);
        }
        return Mono.from(this.refreshTokenPersistence.getAuthentication(validRefreshToken.get())).map(authentication -> this.loginHandler.loginRefresh((Authentication)authentication, refreshToken, request));
    }

    @NonNull
    private String resolveRefreshToken(TokenRefreshRequest tokenRefreshRequest, String cookieRefreshToken) {
        String refreshToken = null;
        if (tokenRefreshRequest != null) {
            if (StringUtils.isEmpty((CharSequence)tokenRefreshRequest.getGrantType()) || StringUtils.isEmpty((CharSequence)tokenRefreshRequest.getRefreshToken())) {
                throw new OauthErrorResponseException(IssuingAnAccessTokenErrorCode.INVALID_REQUEST, "refresh_token and grant_type are required", null);
            }
            if (!tokenRefreshRequest.getGrantType().equals("refresh_token")) {
                throw new OauthErrorResponseException(IssuingAnAccessTokenErrorCode.UNSUPPORTED_GRANT_TYPE, "grant_type must be refresh_token", null);
            }
            refreshToken = tokenRefreshRequest.getRefreshToken();
        } else if (cookieRefreshToken != null) {
            refreshToken = cookieRefreshToken;
        } else {
            throw new OauthErrorResponseException(IssuingAnAccessTokenErrorCode.INVALID_REQUEST, "refresh_token and grant_type are required", null);
        }
        if (StringUtils.isEmpty((CharSequence)refreshToken)) {
            throw new OauthErrorResponseException(IssuingAnAccessTokenErrorCode.INVALID_REQUEST, "refresh_token is required", null);
        }
        return refreshToken;
    }
}

