/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.config;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.context.ServerContextPathProvider;
import io.micronaut.http.uri.UriBuilder;
import java.net.URI;

@Internal
public final class ServerContextPathProviderUtils {
    private ServerContextPathProviderUtils() {
    }

    @NonNull
    public static String prependContextPath(@NonNull String url, @NonNull ServerContextPathProvider serverContextPathProvider) {
        URI uri = URI.create(url);
        if (uri.isAbsolute()) {
            return url;
        }
        String contextPath = serverContextPathProvider.getContextPath();
        if (!StringUtils.hasText((CharSequence)contextPath)) {
            return url;
        }
        return UriBuilder.of((CharSequence)"/").path(contextPath).path(url).build().toString();
    }
}

