/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.cookie;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.CookieConfiguration;
import io.micronaut.security.authentication.CookieBasedAuthenticationModeCondition;
import io.micronaut.security.config.RedirectConfiguration;
import io.micronaut.security.config.RedirectService;
import io.micronaut.security.handlers.LogoutHandler;
import io.micronaut.security.token.cookie.AccessTokenCookieConfiguration;
import io.micronaut.security.token.cookie.RefreshTokenCookieConfiguration;
import jakarta.inject.Singleton;
import java.net.URI;
import java.net.URISyntaxException;

@Requirements(value={@Requires(classes={MutableHttpResponse.class, HttpRequest.class}), @Requires(condition=CookieBasedAuthenticationModeCondition.class)})
@Singleton
public class TokenCookieClearerLogoutHandler
implements LogoutHandler<HttpRequest<?>, MutableHttpResponse<?>> {
    @Nullable
    protected final String logout;
    protected final AccessTokenCookieConfiguration accessTokenCookieConfiguration;
    protected final RefreshTokenCookieConfiguration refreshTokenCookieConfiguration;

    public TokenCookieClearerLogoutHandler(AccessTokenCookieConfiguration accessTokenCookieConfiguration, RefreshTokenCookieConfiguration refreshTokenCookieConfiguration, RedirectConfiguration redirectConfiguration, RedirectService redirectService) {
        this.accessTokenCookieConfiguration = accessTokenCookieConfiguration;
        this.refreshTokenCookieConfiguration = refreshTokenCookieConfiguration;
        this.logout = redirectConfiguration.isEnabled() ? redirectService.logoutUrl() : null;
    }

    @Override
    public MutableHttpResponse<?> logout(HttpRequest<?> request) {
        try {
            MutableHttpResponse response = this.logout == null ? HttpResponse.ok() : HttpResponse.seeOther((URI)new URI(this.logout));
            this.clearCookie(this.accessTokenCookieConfiguration, response);
            if (this.refreshTokenCookieConfiguration != null) {
                this.clearCookie(this.refreshTokenCookieConfiguration, response);
            }
            return response;
        }
        catch (URISyntaxException var5) {
            return HttpResponse.serverError();
        }
    }

    private void clearCookie(CookieConfiguration cookieConfiguration, MutableHttpResponse<?> response) {
        String domain = cookieConfiguration.getCookieDomain().orElse(null);
        String path = cookieConfiguration.getCookiePath().orElse(null);
        Cookie cookie = Cookie.of((String)cookieConfiguration.getCookieName(), (String)"");
        cookie.maxAge(0L).domain(domain).path(path);
        response.cookie(cookie);
    }
}

