/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token;

import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.token.DefaultRolesFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@DefaultImplementation(value=DefaultRolesFinder.class)
public interface RolesFinder {
    default public boolean hasAnyRequiredRoles(@NonNull List<String> requiredRoles, @Nullable Map<String, Object> attributes) {
        return this.hasAnyRequiredRoles(requiredRoles, this.resolveRoles(attributes));
    }

    default public boolean hasAnyRequiredRoles(@NonNull List<String> requiredRoles, @NonNull Collection<String> grantedRoles) {
        ArrayList<String> l = new ArrayList<String>(requiredRoles);
        l.retainAll(grantedRoles);
        return !l.isEmpty();
    }

    @NonNull
    public List<String> resolveRoles(@Nullable Map<String, Object> var1);
}

