/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.endpoints.introspection;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.endpoints.introspection.IntrospectionProcessor;
import io.micronaut.security.endpoints.introspection.IntrospectionRequest;
import io.micronaut.security.endpoints.introspection.IntrospectionResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@Controller(value="${micronaut.security.endpoints.introspection.path:/token_info}")
@Secured(value={"isAuthenticated()"})
public class IntrospectionController {
    private static final Logger LOG = LoggerFactory.getLogger(IntrospectionController.class);
    protected final IntrospectionProcessor processor;

    public IntrospectionController(IntrospectionProcessor processor) {
        this.processor = processor;
    }

    @Post
    @Consumes(value={"application/x-www-form-urlencoded"})
    @SingleResult
    public Publisher<MutableHttpResponse<?>> tokenInfo(@NonNull @Body @Valid @NotNull IntrospectionRequest introspectionRequest, @NonNull HttpRequest<?> request) {
        return Flux.from(this.processor.introspect(introspectionRequest, request)).map(this::introspectionResponseAsJsonString).defaultIfEmpty((Object)this.introspectionResponseAsJsonString(new IntrospectionResponse(false))).map(HttpResponse::ok);
    }

    @Get
    @SingleResult
    public Publisher<MutableHttpResponse<?>> echo(@NonNull Authentication authentication, @NonNull HttpRequest<?> request) {
        return Flux.from(this.processor.introspect(authentication, request)).map(this::introspectionResponseAsJsonString).defaultIfEmpty((Object)this.introspectionResponseAsJsonString(new IntrospectionResponse(false))).map(HttpResponse::ok);
    }

    @NonNull
    private String introspectionResponseAsJsonString(@NonNull IntrospectionResponse introspectionResponse) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString((Object)introspectionResponse);
        }
        catch (JsonProcessingException e) {
            LOG.warn("{}", (Object)e.getMessage());
            return "{\"active:\" false}";
        }
    }
}

