/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.context.annotation.Primary;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.Link;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.security.authentication.AuthenticationException;
import jakarta.inject.Singleton;
import java.net.URI;

@Singleton
@Primary
@Produces
public class AuthenticationExceptionHandler
implements ExceptionHandler<AuthenticationException, MutableHttpResponse<?>> {
    protected final ApplicationEventPublisher eventPublisher;

    public AuthenticationExceptionHandler(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public MutableHttpResponse<?> handle(HttpRequest request, AuthenticationException exception) {
        JsonError error = new JsonError(exception.getMessage());
        error.link(Link.SELF, Link.of((URI)request.getUri()));
        return HttpResponse.unauthorized().body((Object)error);
    }
}

