/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.authentication.ServerAuthentication;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public interface Authentication
extends Principal,
Serializable {
    @NonNull
    public Map<String, Object> getAttributes();

    @NonNull
    default public Collection<String> getRoles() {
        return Collections.emptyList();
    }

    @NonNull
    public static Authentication build(@NonNull String username) {
        return Authentication.build(username, null, null);
    }

    @NonNull
    public static Authentication build(@NonNull String username, @NonNull Collection<String> roles) {
        return Authentication.build(username, roles, null);
    }

    @NonNull
    public static Authentication build(@NonNull String username, @NonNull Map<String, Object> attributes) {
        return new ServerAuthentication(username, null, attributes);
    }

    @NonNull
    public static Authentication build(@NonNull String username, @Nullable Collection<String> roles, @Nullable Map<String, Object> attributes) {
        return new ServerAuthentication(username, roles, attributes);
    }
}

