/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.rules;

import io.micronaut.security.rules.SecurityRule;
import io.micronaut.security.rules.SecurityRuleResult;
import io.micronaut.security.token.MapClaims;
import io.micronaut.security.token.RolesFinder;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSecurityRule
implements SecurityRule {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSecurityRule.class);
    private final RolesFinder rolesFinder;

    @Inject
    public AbstractSecurityRule(RolesFinder rolesFinder) {
        this.rolesFinder = rolesFinder;
    }

    protected List<String> getRoles(Map<String, Object> claims) {
        ArrayList<String> roles = new ArrayList<String>();
        if (claims == null) {
            roles.add("isAnonymous()");
        } else {
            if (!claims.isEmpty()) {
                roles.addAll(this.rolesFinder.findInClaims(new MapClaims(claims)));
            }
            roles.add("isAnonymous()");
            roles.add("isAuthenticated()");
        }
        return roles;
    }

    protected SecurityRuleResult compareRoles(List<String> requiredRoles, List<String> grantedRoles) {
        if (this.rolesFinder.hasAnyRequiredRoles(requiredRoles, grantedRoles)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The given roles [{}] matched one or more of the required roles [{}]. Allowing the request", grantedRoles, requiredRoles);
            }
            return SecurityRuleResult.ALLOWED;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("None of the given roles [{}] matched the required roles [{}]. Rejecting the request", grantedRoles, requiredRoles);
        }
        return SecurityRuleResult.REJECTED;
    }
}

