/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.http.filter.OncePerRequestHttpServerFilter;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.filters.SecurityFilter;
import jakarta.inject.Singleton;
import java.util.Optional;

@Singleton
public class AuthenticationArgumentBinder
implements TypedRequestArgumentBinder<Authentication> {
    public Argument<Authentication> argumentType() {
        return Argument.of(Authentication.class);
    }

    public ArgumentBinder.BindingResult<Authentication> bind(ArgumentConversionContext<Authentication> context, HttpRequest<?> source) {
        if (source.getAttributes().contains(OncePerRequestHttpServerFilter.getKey(SecurityFilter.class))) {
            Optional existing = source.getUserPrincipal(Authentication.class);
            if (existing.isPresent()) {
                return () -> existing;
            }
            return ArgumentBinder.BindingResult.EMPTY;
        }
        return ArgumentBinder.BindingResult.UNSATISFIED;
    }
}

