/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.security.authentication.AuthorizationException;
import io.micronaut.security.config.RedirectConfiguration;
import io.micronaut.security.errors.PriorToLoginPersistence;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultAuthorizationExceptionHandler
implements ExceptionHandler<AuthorizationException, MutableHttpResponse<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAuthorizationExceptionHandler.class);
    private final RedirectConfiguration redirectConfiguration;
    private final PriorToLoginPersistence priorToLoginPersistence;

    public DefaultAuthorizationExceptionHandler() {
        this.redirectConfiguration = null;
        this.priorToLoginPersistence = null;
    }

    @Inject
    public DefaultAuthorizationExceptionHandler(RedirectConfiguration redirectConfiguration, @Nullable PriorToLoginPersistence priorToLoginPersistence) {
        this.redirectConfiguration = redirectConfiguration;
        this.priorToLoginPersistence = priorToLoginPersistence;
    }

    public MutableHttpResponse<?> handle(HttpRequest request, AuthorizationException exception) {
        if (this.shouldRedirect(request, exception)) {
            try {
                URI location = new URI(this.getRedirectUri(request, exception));
                if (!request.getUri().equals(location)) {
                    MutableHttpResponse<?> response = this.httpResponseWithStatus(location);
                    if (this.priorToLoginPersistence != null && !exception.isForbidden()) {
                        this.priorToLoginPersistence.onUnauthorized(request, response);
                    }
                    return response;
                }
                return this.httpResponseWithStatus(request, exception);
            }
            catch (URISyntaxException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Rejection redirect URL is invalid", (Throwable)e);
                }
                return HttpResponse.serverError();
            }
        }
        return this.httpResponseWithStatus(request, exception);
    }

    protected MutableHttpResponse<?> httpResponseWithStatus(HttpRequest request, AuthorizationException exception) {
        return HttpResponse.status((HttpStatus)(exception.isForbidden() ? HttpStatus.FORBIDDEN : HttpStatus.UNAUTHORIZED));
    }

    protected boolean shouldRedirect(HttpRequest<?> request, AuthorizationException exception) {
        if (this.redirectConfiguration != null) {
            return (exception.isForbidden() && this.redirectConfiguration.getForbidden().isEnabled() || !exception.isForbidden() && this.redirectConfiguration.getUnauthorized().isEnabled()) && request.getHeaders().accept().stream().anyMatch(mediaType -> mediaType.equals((Object)MediaType.TEXT_HTML_TYPE));
        }
        return false;
    }

    protected String getRedirectUri(HttpRequest<?> request, AuthorizationException exception) {
        String uri;
        String string = uri = exception.isForbidden() ? this.redirectConfiguration.getForbidden().getUrl() : this.redirectConfiguration.getUnauthorized().getUrl();
        if (LOG.isDebugEnabled()) {
            LOG.debug("redirect uri: {}", (Object)uri);
        }
        return uri;
    }

    protected MutableHttpResponse<?> httpResponseWithStatus(URI location) {
        return HttpResponse.status((HttpStatus)HttpStatus.SEE_OTHER).headers(headers -> headers.location(location));
    }
}

