/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.config;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class InterceptUrlMapPattern {
    private final String pattern;
    private final List<String> access;
    private final Optional<HttpMethod> httpMethod;

    public InterceptUrlMapPattern(String pattern, List<String> access, @Nullable HttpMethod httpMethod) {
        this.pattern = pattern;
        this.access = access;
        this.httpMethod = Optional.ofNullable(httpMethod);
    }

    public String getPattern() {
        return this.pattern;
    }

    public List<String> getAccess() {
        return new ArrayList<String>(this.access);
    }

    public Optional<HttpMethod> getHttpMethod() {
        return this.httpMethod;
    }
}

