/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.security.authentication.AuthenticationResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class UserDetails
implements AuthenticationResponse {
    private String username;
    private Collection<String> roles;
    private Map<String, Object> attributes;

    public UserDetails(String username, Collection<String> roles) {
        this(username, roles, null);
    }

    public UserDetails(String username, Collection<String> roles, Map<String, Object> attributes) {
        if (username == null || roles == null) {
            throw new IllegalArgumentException("Cannot construct a UserDetails with a null username or authorities");
        }
        this.username = username;
        this.roles = roles;
        this.attributes = attributes;
    }

    public Map<String, Object> getAttributes(String rolesKey, String usernameKey) {
        HashMap<String, Object> result = this.attributes == null ? new HashMap<String, Object>() : new HashMap<String, Object>(this.attributes);
        result.putIfAbsent(rolesKey, this.getRoles());
        result.putIfAbsent(usernameKey, this.getUsername());
        return result;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        if (username == null) {
            throw new IllegalArgumentException("Cannot set username to null");
        }
        this.username = username;
    }

    public Collection<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Collection<String> roles) {
        if (roles == null) {
            throw new IllegalArgumentException("Cannot set roles to null");
        }
        this.roles = roles;
    }

    public void setAttributes(@Nullable Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDetails that = (UserDetails)o;
        return this.username.equals(that.username);
    }

    public int hashCode() {
        return this.username.hashCode();
    }

    @Override
    public Optional<UserDetails> getUserDetails() {
        return Optional.of(this);
    }

    @Override
    public Optional<String> getMessage() {
        return Optional.empty();
    }
}

