/*
 * Copyright 2017-2020 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micronaut.security.token.propagation;

import io.micronaut.core.order.Ordered;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpRequest;

import java.util.Optional;

/**
 * Responsible for retrieving and writing tokens for the purpose
 * of propagation between services.
 *
 * @author James Kleeh
 * @since 1.4.0
 */
public interface TokenPropagator extends Ordered {

    /**
     * Writes the token to the request.
     *
     * @param request The {@link MutableHttpRequest} instance
     * @param token A token ( e.g. JWT token, basic auth token...)
     */
    void writeToken(MutableHttpRequest<?> request, String token);

    /**
     * Attempts to retrieve a token in a request.
     *
     * @param request The request to look for the token in
     * @return An optional token string
     */
    Optional<String> findToken(HttpRequest<?> request);
}
